package com.webonlineapp;

import java.util.Arrays;

import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HomePage extends WebPage {
	private static final long serialVersionUID = 1L;
	
	private String selectedChart = "Line";
	

	/**
	 * 
	 * @param parameters
	 */
	public HomePage(final PageParameters parameters) {
		super(parameters);
		add(buildPage());
	}
	
	/**
	 * 
	 * @return
	 */
	private Form<Object> buildPage() {
	    Form<Object> form = new Form<Object>("form");
	    
		DropDownChoice<String> ddc = 
				new DropDownChoice<String>("charts", 
						new PropertyModel<String>(this, "selectedChart"), Arrays.asList(new String[] {"Line", "Pie"}));
		form.add(ddc);

	    Button displayButton = new Button("display") {
			private static final long serialVersionUID = -467877231483133183L;

			public void onSubmit() {
	            PageParameters params = new PageParameters();
	            params.add("param1", selectedChart);
	            
	            setResponsePage(new ChartPage(params));
	        }
	    };
	    form.add(displayButton);
	    
	    return form;
	}
	

	public String getSelectedChart() {
		return selectedChart;
	}

	public void setSelectedChart(String selectedChart) {
		this.selectedChart = selectedChart;
	}

}
