package com.webonlineapp;

import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;

import com.hyjavacharts.chart.Highchart;

public class ChartPage extends WebPage {
	private static final long serialVersionUID = 1L;
	
	/**
	 * Build the selected chart
	 * @param parameters
	 */
	public ChartPage(final PageParameters parameters) {
		super(parameters);
		String selectedChart = parameters.get("param1").toString();
        
        Highchart hc = null;
        if (selectedChart.equals("Line")) {
        	hc = new BasicLine().configure();
    		String chartOptionsScript = "Highcharts.chart('container', " + hc.chartOptionsToJs() + ");";
    		
    		add(new Label("script", chartOptionsScript).setEscapeModelStrings(false));
        }
        else {
        	hc = new PieChart().configure();
      		String chartOptionsScript = "Highcharts.chart('container', " + hc.chartOptionsToJs() + ");";
    		
    		add(new Label("script", chartOptionsScript).setEscapeModelStrings(false));
        }
	}

}
