package com.webonlineapp.simpledemo;

import java.util.ArrayList;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.router.Route;

@Route("")
public class MainView extends VerticalLayout {
	private static final long serialVersionUID = 5516451139589179962L;
	

	/**
	 * 
	 */
	public MainView() {
        add(buildPage());
    }
	
	/**
     * 
     * @return
     */
    private Component buildPage() {
    	VerticalLayout layout = new VerticalLayout();
    	
    	List<String> charts = new ArrayList<>();
    	charts.add("Line");
    	charts.add("Pie");

    	Select<String> select =  new Select<>("Select Chart");
    	select.setItems(charts);
     	select.setValue("Line");
    	add(select);
    	
        Button button = new Button("Display Chart");
        button.addThemeVariants(ButtonVariant.LUMO_PRIMARY);
        add(button);
        
        VerticalLayout chartComponent = new VerticalLayout();
        add(chartComponent);
         
        button.addClickListener(e -> {
            chartComponent.removeAll();;
            chartComponent.add(buildChart(select.getValue()));
        });
 
        return layout;
    }
    
    /**
     * 
     * @param chartName
     * @return
     */
    private Component buildChart(String chartName) {
    	HighchartComponent hcComponent = new HighchartComponent();
    	
    	Highchart hc = null;
    	if (chartName.equals("Line")) {
    		hc = new BasicLine().configure();
    	}
    	else {
    		hc = new PieChart().configure();
    	}
		
		String globalOptionsJs = hc.globalOptionsToJs();
		String chartOptionsJs = hc.chartOptionsToJs();
		
		if (globalOptionsJs != null) {
			hcComponent.displayChart(globalOptionsJs, chartOptionsJs);
		}
		else {
			hcComponent.displayChart(chartOptionsJs);
		}
		
		return hcComponent;
    }
}
