package com.webonlineapp.simpledemo;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.page.Page;

@Tag("div")
@JavaScript("https://code.highcharts.com/7.2.1/highcharts.js")
@JavaScript("https://code.highcharts.com/7.2.1/modules/exporting.js")
public class HighchartComponent extends Component implements HasComponents, HasSize {
	private static final long serialVersionUID = 806054527112127036L;
	
	private static long chartId = 1;
	
	
	/**
	 * 
	 */
	public HighchartComponent() { 
        setId("highchart_" + getNextChartId());
 	}
	
	/**
	 * 
	 * @param chartOptions
	 */
	public void displayChart(String chartOptions) {
		displayChart("", chartOptions);
	}
	
	/**
	 * 
	 * @param globalOptions
	 * @param chartOptions
	 */
	public void displayChart(String globalOptions, String chartOptions) {
		Page page = UI.getCurrent().getPage();
		
		if (globalOptions != null && !globalOptions.equals("")) {
			String globalOptionsJs = "Highcharts.setOptions(" + globalOptions + ");";
			page.executeJs(globalOptionsJs);
		}

    	String chartOptionsJs = "Highcharts.chart('" + getId().get() + "', " + chartOptions + ");";
    	page.executeJs(chartOptionsJs);
	}
	
	/**
	 * 
	 * @return
	 */
	private long getNextChartId() {
		chartId++;
		
		if (chartId > 10000) {
			chartId = 1;
		}
		
		return chartId;
	}
	
}
