package com.webonlineapp.simpledemo;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;

public class PieChart {

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.PIE)
			.setPlotShadowAsBoolean(false)
			.setPlotBackgroundColor(null)
			.setPlotBorderWidth(null);
		chartOptions.getTitle().setText("Browser market shares in January, 2018");
		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions()
			.getPie()
				.setAllowPointSelect(true)
				.setCursor(Cursor.POINTER)
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b>: {point.percentage:.1f} %")
					.getStyle().setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"));
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Brands").setColorByPoint(true);
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	public ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Chrome").setY(61.41).setSliced(true).setSelected(true));
		array.add(new Data().setName("Internet Explorer").setY(11.84));
		array.add(new Data().setName("Firefox").setY(10.85));
		array.add(new Data().setName("Edge").setY(4.67));
		array.add(new Data().setName("Safari").setY(4.18));
		array.add(new Data().setName("Sogou Explorer").setY(1.64));
		array.add(new Data().setName("Opera").setY(1.6));
		array.add(new Data().setName("QQ").setY(1.2));
		array.add(new Data().setName("Other").setY(2.61));

		return array;
	}
}
