package com.webonlineapp.simpledemo;

import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.JavaScript;

@com.vaadin.annotations.JavaScript({
	"jquery-3.2.1.min.js", 
	"https://code.highcharts.com/7.2.1/highcharts.js",
	"https://code.highcharts.com/7.2.1/modules/exporting.js",
	"highcharts-connector.js"})

public class HighChartComponent extends AbstractJavaScriptComponent {
    private static final long serialVersionUID = 7738496276049495017L;
    public static int currChartId = 0;
    protected int chartId = nextChartId();
    private String json;

    /**
     * Creates the chart object.
     */
    public HighChartComponent() {
        setId(getDomId());
        getState().domId = getDomId();
        getState().hcjs = "";
    }

    /**
     * 
     * @return
     */
    public static int nextChartId() {
        return ++currChartId;
    }

    /**
     * 
     */
    public void reRender() {
        int componentIndex;

        AbstractOrderedLayout container = (AbstractOrderedLayout) this.getParent();
        componentIndex = container.getComponentIndex(this);
        container.getComponentIndex(this);
        container.removeComponent(this);
        container.addComponent(HighChartFactory.renderChart(json), componentIndex);
    }

    /**
     * 
     */
    @Override
    protected HighChartState getState() {
        return (HighChartState) super.getState();
    }

    /**
     * 
     * @return
     */
    public String getDomId() {
        return "highchart_" + chartId;
    }

    /**
     * 
     * @param json
     */
    public void setChartoptions(String json) {
    	this.json = json;
        getState().hcjs = "var options = " + json;
    }

    /**
     * 
     * @param json
     */
    public void redraw(String json) {
        this.setChartoptions(json);
        JavaScript.getCurrent().execute("$(\"#" + this.getDomId() + "\").redraw();");
    }
    
    /**
     * 
     * @param js
     */
	public void manipulateChart(String js) {
		JavaScript.eval("var chart = $('#" + getDomId() + "').highcharts();\n" + js);
	}
	
	/**
	 * 
	 * @param js
	 */
	public void setOptions(String js) {
		String Highcharts_setOptions = "Highcharts.setOptions(" + js + ");";
		
		JavaScript.eval(Highcharts_setOptions);
	}
}