package com.webonlineapp.simpledemo;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.annotation.WebServlet;

import com.hyjavacharts.chart.Highchart;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a Vaadin application.
 * 
 */
@Theme("demotheme")
public class DemoUI extends UI {
	private static final long serialVersionUID = -4384922097192602164L;

	@Override
    protected void init(VaadinRequest vaadinRequest) {
    	final VerticalLayout layout = new VerticalLayout();
         
        layout.addComponent(buildPage());
        
        setContent(layout);
    }
    
    /**
     * 
     * @return
     */
    private Component buildPage() {
    	VerticalLayout layout = new VerticalLayout();
    	
    	List<String> charts = new ArrayList<>();
    	charts.add("Line");
    	charts.add("Pie");

    	ComboBox<String> select =  new ComboBox<>("Select Chart");
    	select.setItems(charts);
    	select.setTextInputAllowed(false);
    	select.setEmptySelectionAllowed(false);
    	select.setValue("Line");
    	layout.addComponent(select);
    	
        Button button = new Button("Display Chart");
        layout.addComponent(button);
        
        VerticalLayout chartComponent = new VerticalLayout();
        layout.addComponent(chartComponent);
         
        button.addClickListener(e -> {
            chartComponent.removeAllComponents();
            chartComponent.addComponent(buildChart(select.getValue()));
        });
 
        return layout;
    }
    
    /**
     * 
     * @return
     */
    private Component buildChart(String chartName) {
    	HighChartComponent hcComponent = new HighChartComponent();
    	
    	Highchart hc = null;
    	if (chartName.equals("Line")) {
    		hc = new BasicLine().configure();
    	}
    	else {
    		hc = new PieChart().configure();
    	}
		
		String globalOptionsJs = hc.globalOptionsToJs();
		String chartOptionsJs = hc.chartOptionsToJs();
		
		if (globalOptionsJs != null) 
			hcComponent.setOptions(globalOptionsJs);
		hcComponent.setChartoptions(chartOptionsJs);
		
		return hcComponent;
    }
    

    @WebServlet(urlPatterns = "/*", name = "DemoUIServlet", asyncSupported = true)
    @VaadinServletConfiguration(ui = DemoUI.class, productionMode = false)
    public static class DemoUIServlet extends VaadinServlet {
		private static final long serialVersionUID = -7065516492723139427L;
    }
}
