package com.webonlineapp.controller;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.hyjavacharts.chart.Highchart;
import com.webonlineapp.charts.BasicLine;
import com.webonlineapp.charts.PieChart;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a Spring application.
 * 
 * NOTE: We are not experts in Spring so there will no doubt be better ways to accomplish the same thing.
 * 
 */
@Controller
public class Demo {
	
	/**
	 * 
	 * @return
	 */
	@RequestMapping("/")
	public ModelAndView home() {
		return new ModelAndView("home");
	}
	
	/**
	 * 
	 * @param chartName
	 * @return
	 */
	@RequestMapping("/displaychart")
	public ModelAndView displayChart(@RequestParam String chartName) {
		Highchart hc = null;
		
		if (chartName.equals("line")) {
			hc = new BasicLine().configure();
		}
		else {
			hc = new PieChart().configure();
		}
		
		String globalOptions = hc.globalOptionsToJs();
		String chartOptions = hc.chartOptionsToJs();
	    
		Map<String, Object> chartModel = new HashMap<String, Object>();

		chartModel.put("chartName", chartName);
		chartModel.put("globalOptions", globalOptions);
		chartModel.put("chartOptions", chartOptions);
	    
	    return new ModelAndView("displaychart", "model", chartModel);
	}
}
