package com.webonlineapp;
	
import com.hyjavacharts.chart.Highchart;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a JavaFX application.
 * 
 * NOTE: We are not experts in JavaFx so there will no doubt be better ways to accomplish the same thing.
 * 
 */
public class Main extends Application {

    @Override
    public void start(Stage primaryStage) {
    	VBox root = new VBox();
    	
        WebView webView = new WebView();
        WebEngine engine = webView.getEngine();

        HBox buttons = new HBox();
        buttons.setSpacing(10);
        buttons.setPadding(new Insets(15, 12, 15, 12));
        
        Button lineChartButton = new Button("Line Chart");
        buttons.getChildren().add(lineChartButton);
        
        Button dynamicChartButton = new Button("Pie Chart");
        buttons.getChildren().add(dynamicChartButton);
        
        root.getChildren().add(buttons);
        root.getChildren().add(webView);
        
        lineChartButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override public void handle(ActionEvent e) {
            	engine.loadContent(buildContent("line"));
            }
        });
        
        dynamicChartButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override public void handle(ActionEvent e) {
            	engine.loadContent(buildContent("pie"));
            }
        });

        primaryStage.setScene(new Scene(new BorderPane(root)));
        primaryStage.show();
    }
    
    /**
     * 
     * @return
     */
    private String buildContent(String chart) {
    	Highchart hc = null;
    	
    	if (chart.equals("line")) {
    		hc = new BasicLine().configure();
    	}
    	else {
    		hc = new PieChart().configure();
    	}
     	
    	return "<script src=https://code.highcharts.com/7.2.1/highcharts.js></script>\r\n" + 
        		"<div id=\"container\" style=\"min-width: 310px; max-width: 800px; height: 400px; margin: 0 auto\"></div>\r\n" + 
        		"<script>\r\n" + 
        		(hc.globalOptionsToJs() == null ? "" : "Highcharts.setOptions(" + hc.globalOptionsToJs() + ");\r\n") + 
        		"Highcharts.chart('container', " + hc.chartOptionsToJs() + " );\r\n" + 
        		"</script>";
    }
    
    /**
     * 
     * @param args
     */
	public static void main(String[] args) {
		launch(args);
	}
}
