package com.webonlineapp;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.hyjavacharts.chart.Highchart;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a JSP application.
 * 
 * The 2 Charts available are:
 * ?chart=line
 * ?chart=pie
 * 
 * NOTE: We are not experts using JSP's so there will no doubt be better ways to accomplish the same thing.
 * 
 */
@WebServlet("/")
public final class DemoServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;


    /**
     * 
     */
    protected void doGet(final HttpServletRequest req, final HttpServletResponse resp)
            throws ServletException, IOException {

        handleRequestForGreeting(req, resp);
    }

    /**
     * 
     */
    protected void doPost(final HttpServletRequest req, final HttpServletResponse resp)
            throws ServletException, IOException {

        handleRequestForGreeting(req, resp);
    }

    /**
     * 
     * @param req
     * @param resp
     * @throws ServletException
     * @throws IOException
     */
    private void handleRequestForGreeting(final HttpServletRequest req, final HttpServletResponse resp)
            throws ServletException, IOException {
    	
    	String reqChart = req.getParameter("chart") == null ? "line" : req.getParameter("chart");
    	
    	String globalOptionsJs = "";
    	String chartOptionsJs = "";
    	
		Highchart hc = null;
		
		if (reqChart.equals("line")) {
    		hc = new BasicLine().configure();
    		chartOptionsJs = hc.chartOptionsToJs();
    	}
    	else {
    		hc = new PieChart().configure();
    		chartOptionsJs = hc.chartOptionsToJs();
    	}
    	
    	req.setAttribute("globalOptions", globalOptionsJs);
        req.setAttribute("chartOptions", chartOptionsJs);
 
        req.getRequestDispatcher("/demochart.jsp").forward(req, resp);
    }

}
