package com.webonlineapp;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;

import com.hyjavacharts.chart.Highchart;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a JSF application.
 * 
 * NOTE: We are not experts in JSF so there will no doubt be better ways to accomplish the same thing.
 * 
 */
@ManagedBean
@RequestScoped 
public class ChartDemo implements Serializable {

	private static final long serialVersionUID = 1L;	

	private String chartName = "line";
	private String globalOptions = "";
	private String chartOptions = "";
	

	/**
	 * 
	 * @return
	 */
	public String chartSelect() {
		Highchart hc = null;
		
		if (chartName.equals("line")) {
			hc = new BasicLine().configure();
			chartOptions = hc.chartOptionsToJs();
		}
		else {
			hc = new PieChart().configure();
			chartOptions = hc.chartOptionsToJs();
		}
		
		return "demoresponse";
	}

	public String getChartOptions() {
		return chartOptions;
	}

	public void setChartOptions(String chartOptions) {
		this.chartOptions = chartOptions;
	}

	public String getChartName() {
		return chartName;
	}

	public void setChartName(String chartName) {
		this.chartName = chartName;
	}

	public String getGlobalOptions() {
		return globalOptions;
	}

	public void setGlobalOptions(String globalOptions) {
		this.globalOptions = globalOptions;
	}

}
