package com.webonlineapp.gwtdemo.server;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.hyjavacharts.chart.Highchart;
import com.webonlineapp.gwtdemo.client.ChartService;

/**
 * The server-side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class ChartServiceImpl extends RemoteServiceServlet implements ChartService {

	/**
	 * Return global and chart js options
	 */
	public Map<String, String> getChartOptions(String chartName) throws IllegalArgumentException {
		String globalOptions = "";
		String chartOptions = "";
		
		Highchart hc = null;
		
		if (chartName.equals("Line")) {
			hc = new BasicLine().configure();
			chartOptions = hc.chartOptionsToJs();
		}
		else {
			hc = new PieChart().configure();
			chartOptions = hc.chartOptionsToJs();
		}
		
		Map<String, String> optionsMap = new HashMap<String, String>();
		optionsMap.put("globalOptions", globalOptions);
		optionsMap.put("chartOptions", chartOptions);
		
		return optionsMap;
	}


}
