package com.webonlineapp.gwtdemo.client;

import java.util.Map;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RootPanel;

/*
 * A simple proof of concept example application to show how to integrate  
 * Highcharts and the HyJavaCharts library in a GWT application.
 * 
 * NOTE: We are not experts in GWT so there will no doubt be better ways to accomplish the same thing.
 * 
 * 
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class HyJavaChartsSimpleGWTDemo implements EntryPoint {

	/**
	 * Create a remote service proxy to talk to the server-side chart service.
	 */
	private final ChartServiceAsync chartService = GWT.create(ChartService.class);

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		ListBox lbSelectChart = new ListBox();
		lbSelectChart.setName("chartSelect");
		lbSelectChart.addItem("Line");
		lbSelectChart.addItem("Pie");
		lbSelectChart.setVisibleItemCount(1);

		final Button displayButton = new Button("Display");
		displayButton.addStyleName("sendButton");

		RootPanel.get("chartNameFieldContainer").add(lbSelectChart);
		RootPanel.get("displayButtonContainer").add(displayButton);

		lbSelectChart.setFocus(true);

		// Create a handler for the displayButton and chartNameField
		class MyHandler implements ClickHandler {
			/**
			 * Fired when the user clicks on the displayButton.
			 */
			public void onClick(ClickEvent event) {
				sendChartNameToServer();
			}

			/**
			 * Send the selected chart name to the server and wait for a response.
			 */
			private void sendChartNameToServer() {
				String chartNameToServer = lbSelectChart.getSelectedValue();
				displayButton.setEnabled(false);

				chartService.getChartOptions(chartNameToServer, new AsyncCallback<Map<String, String>>() {
					public void onFailure(Throwable caught) {
					}

					public void onSuccess(Map<String, String> optionsMap) {
						String globalOptionsJs = "Highcharts.setOptions(" + optionsMap.get("globalOptions") + ");";
						String chartOptionsJs = "Highcharts.chart('container', " + optionsMap.get("chartOptions") + ");";

						// Inject the highcharts chart options js
						if (!optionsMap.get("globalOptions").equals("")) {
							ScriptInjector.fromString(globalOptionsJs).setWindow(ScriptInjector.TOP_WINDOW).inject();
						}
						ScriptInjector.fromString(chartOptionsJs).setWindow(ScriptInjector.TOP_WINDOW).inject();

						displayButton.setEnabled(true);
					}
				});
			}
		}

		// Add a handler to send the chart name to the server
		MyHandler handler = new MyHandler();
		displayButton.addClickHandler(handler);
	}
}
