package com.webonlineapp;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.hyjavacharts.chart.Highchart;

/*
 * A very primitive and simple proof of concept example to show how to integrate 
 * Highcharts and HyJavaCharts library in a web application.
 * 
 * The 2 Charts available are:
 * ?chart=line
 * ?chart=pie
 * 
 */
public class HyJavaChartsSimpleDemo extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    /**
     * 
     */
    public HyJavaChartsSimpleDemo() {
        super();
    }

	/**
	 * 
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String reqChart = request.getParameter("chart") == null ? "line" : request.getParameter("chart");
		
		Highchart hc = null;
    	
    	if (reqChart.equals("line")) {
    		hc = new BasicLine().configure();
    	}
    	else {
    		hc = new PieChart().configure();
    	}
		
		response.setContentType("text/html");
        PrintWriter printWriter  = response.getWriter();
        
        // Add javascript
        printWriter.println("<script src=\"https://code.highcharts.com/7.2.1/highcharts.js\"></script>");
        printWriter.println("<script src=\"https://code.highcharts.com/7.2.1/modules/exporting.js\"></script>");
        
        printWriter.println("<div id=\"container\" style=\"min-width: 310px; max-width: 800px; height: 400px; margin: 0 auto\"></div>");
        
        printWriter.println("<script>");
        
        // handle any global chart options
        String global = hc.globalOptionsToJs();
        if (global != null) {
        	printWriter.println("Highcharts.setOptions(" + global + ");");
        }
        
        // chart options
        printWriter.println("Highcharts.chart('container', " + hc.chartOptionsToJs() + ");");
        
        printWriter.println("</script>");
	}

	/**
	 * 
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}

}
