package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesXrange;
import com.hyjavacharts.model.highcharts.series.seriesxrange.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.util.DateUtil;

public class XRangeSeries extends DemoChartBase {
	private static final long serialVersionUID = 6524991966214012533L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.XRANGE);
		chartOptions.getTitle().setText("Highcharts X-range");
		
		chartOptions.getXAxisSingle().setType(AxisType.DATETIME);
		chartOptions.getYAxisSingle()
			.setCategories(Arrays.asList("Prototyping", "Development", "Testing"))
			.setReversed(true)
			.getTitle().setText("");
		
		SeriesXrange seriesXrange = new SeriesXrange();
		seriesXrange.setName("Project 1")
			.setBorderColor(new Color("gray"))
			.setPointWidth(20)
			.getDataLabels().setEnabled(true);
		seriesXrange.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesXrange);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setX(DateUtil.toMilli(2014, 11, 21)).setX2(DateUtil.toMilli(2014, 12, 2)).setY(0).setPartialFillAsNumber(0.25));
		array.add(new Data().setX(DateUtil.toMilli(2014, 12, 2)).setX2(DateUtil.toMilli(2014, 12, 5)).setY(1));
		array.add(new Data().setX(DateUtil.toMilli(2014, 12, 8)).setX2(DateUtil.toMilli(2014, 12, 9)).setY(2));
		array.add(new Data().setX(DateUtil.toMilli(2014, 12, 9)).setX2(DateUtil.toMilli(2014, 12, 19)).setY(1));
		array.add(new Data().setX(DateUtil.toMilli(2014, 12, 10)).setX2(DateUtil.toMilli(2014, 12, 23)).setY(2));

    	return array;
    }
	
}
