package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesVariablepie;
import com.hyjavacharts.model.highcharts.series.seriesvariablepie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class VariableRadiusPie extends DemoChartBase {
	private static final long serialVersionUID = -4942196143300437L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.VARIABLEPIE);
		chartOptions.getTitle().setText("Countries compared by population density and total area.");
		
		chartOptions.getTooltip()
			.setHeaderFormat("")
			.setPointFormat("<span style=\"color:{point.color}\">\u25CF</span> <b> {point.name}</b><br/>Area (square km): <b>{point.y}</b><br/>Population density (people per square km): <b>{point.z}</b><br/>");

		SeriesVariablepie seriesVariablepie = new SeriesVariablepie();
		seriesVariablepie.setName("countries")
			.setMinPointSizeAsNumber(10)
			.setInnerSizeAsString("20%")
			.setZMin(0);
		seriesVariablepie.setDataAsArrayObject(Arrays.asList(
			new Data().setName("Spain").setY(505370).setZ(92.9),
			new Data().setName("France").setY(551500).setZ(118.7),
			new Data().setName("Poland").setY(312685).setZ(124.6),
			new Data().setName("Czech Republic").setY(78867).setZ(137.5),
			new Data().setName("Italy").setY(301340).setZ(201.8),
			new Data().setName("Switzerland").setY(41277).setZ(214.5),
			new Data().setName("Germany").setY(357022).setZ(235.6)
			));
		chartOptions.getSeries().add(seriesVariablepie);
		
		return highChart;
	}
	
}
