package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.Pane;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.MinorTickPosition;
import com.hyjavacharts.model.highcharts.constants.TickPosition;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.yaxis.PlotBands;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class VUMeter extends DemoChartBase {
	private static final long serialVersionUID = 6004006318631403394L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.GAUGE)
			.setPlotBorderWidth(1)
			.setPlotBackgroundImage(null)
			.setHeightAsNumber(200)
			.getPlotBackgroundColor()
				.setStops(Arrays.asList(new Stop(0, new Color("#FFF4C6")), new Stop(0.3, new Color("#FFFFFF")), new Stop(1, new Color("#FFF4C6"))))
				.getLinearGradient().setX1(0).setX2(0).setY1(0).setY2(1);

		chartOptions.getTitle().setText("VU meter");
		
		chartOptions.getPane()
			.add(new Pane()
				.setStartAngle(-45)
				.setEndAngle(45)
				.setBackground(null)
				.setSizeAsNumber(300)
				.setCenterAsArrayString(Arrays.asList("25%", "145%")));
		
		chartOptions.getPane()	
			.add(new Pane()
				.setStartAngle(-45)
				.setEndAngle(45)
				.setBackground(null)
				.setSizeAsNumber(300)
				.setCenterAsArrayString(Arrays.asList("75%", "145%")));
		
		chartOptions.getTooltip().setEnabled(false);

		YAxis yAxis = new YAxis();
		yAxis.setMin(-20)
			.setMax(6)
			.setMinorTickPosition(MinorTickPosition.OUTSIDE)
			.setTickPosition(TickPosition.OUTSIDE)
			.getLabels().setDistanceAsNumber(20);
		yAxis.getPlotBands()
			.add(new PlotBands()
				.setFrom(0)
				.setTo(6)
				.setColor(new Color("#C02316"))
				.setInnerRadiusAsString("100%")
				.setOuterRadiusAsString("105%"));
		yAxis.getTitle().setText("VU<br/><span style=\"font-size:8px\">Channel A</span>").setY(-40);
		yAxis.setPane(0);
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setMin(-20)
			.setMax(6)
			.setMinorTickPosition(MinorTickPosition.OUTSIDE)
			.setTickPosition(TickPosition.OUTSIDE)
			.getLabels().setDistanceAsNumber(20);
		yAxis.getPlotBands()
			.add(new PlotBands()
				.setFrom(0)
				.setTo(6)
				.setColor(new Color("#C02316"))
				.setInnerRadiusAsString("100%")
				.setOuterRadiusAsString("105%"));
		yAxis.getTitle().setText("VU<br/><span style=\"font-size:8px\">Channel B</span>").setY(-40);
		yAxis.setPane(1);
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.getPlotOptions().getGauge().getDataLabels().setEnabled(false);
		chartOptions.getPlotOptions().getGauge().getDial().setRadius("100%");
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Channel A").setYAxisAsNumber(0);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(-15));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Channel B").setYAxisAsNumber(1);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(-3.2));
		chartOptions.getSeries().add(seriesColumn);
		
		chartOptions.getData().setCsvURL(RestService.getURI() + "/VUMeterCSVData")
			.setEnablePolling(true)
			.setDataRefreshRate(3);
		
		return highChart;
	}
	
}
