package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.TimeDataWithIrregularIntervalsData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class TimeDataWithIrregularIntervals extends DemoChartBase {
	private static final long serialVersionUID = -1985106469710217218L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.SPLINE);
		chartOptions.getTitle().setText("Snow depth at Vikjafjellet, Norway");
		chartOptions.getSubtitle().setText("Irregular time data in Highcharts JS");

		XAxis xAxi = new XAxis();
		xAxi.setType(AxisType.DATETIME)
			.getDateTimeLabelFormats().setMonth("%e. %b").setYear("%b");
		xAxi.getTitle().setText("Date");
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setMin(0)
			.getTitle().setText("Snow depth (m)");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip().setHeaderFormat("<b>{series.name}</b><br>").setPointFormat("{point.x:%e. %b}: {point.y:.2f} m");
		chartOptions.getPlotOptions().getSpline().getMarker().setEnabled(true);
		
		chartOptions.setColors(Arrays.asList(
				new Color("#6CF"), new Color("#39F"), new Color("#06C"), new Color("#036"), new Color("#000")));
		
		TimeDataWithIrregularIntervalsData chartData = new TimeDataWithIrregularIntervalsData();
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setName("Winter 2014-2015");
		seriesSpline.setDataAsArrayObject(chartData.getSeriesData(1));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("Winter 2015-2016");
		seriesSpline.setDataAsArrayObject(chartData.getSeriesData(2));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("Winter 2016-2017");
		seriesSpline.setDataAsArrayObject(chartData.getSeriesData(3));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}

}
