package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.coloraxis.DataClasses;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesTilemap;
import com.hyjavacharts.model.highcharts.series.seriestilemap.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class TileMapHoneycomb extends DemoChartBase {
	private static final long serialVersionUID = 1095732812824017854L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setType(ChartType.TILEMAP)
			.setInverted(true);
		chartOptions.getTitle().setText("U.S. states by population in 2016");
		chartOptions.getSubtitle().setText("Source:<a href=\"https://simple.wikipedia.org/wiki/List_of_U.S._states_by_population\">Wikipedia</a>");
		
	    chartOptions.getXAxis().add(new XAxis().setVisible(false));
	    chartOptions.getYAxis().add(new YAxis().setVisible(false));
	    
	    chartOptions.getColorAxisSingle().getDataClasses().add(new DataClasses().setFrom(0).setTo(1000000).setColor(new Color("#F9EDB3")).setName("< 1M"));
	    chartOptions.getColorAxisSingle().getDataClasses().add(new DataClasses().setFrom(1000000).setTo(5000000).setColor(new Color("#FFC428")).setName("1M - 5M"));
	    chartOptions.getColorAxisSingle().getDataClasses().add(new DataClasses().setFrom(5000000).setTo(20000000).setColor(new Color("#FF7987")).setName("5M - 20M"));
	    chartOptions.getColorAxisSingle().getDataClasses().add(new DataClasses().setFrom(20000000).setColor(new Color("#FF2371")).setName("> 20M"));

		chartOptions.getTooltip()
			.setHeaderFormat("")
			.setPointFormat("The population of <b> {point.name}</b> is <b>{point.value}</b>");

		chartOptions.getPlotOptions().getTilemap()
			.getDataLabels()
				.setEnabled(true)
				.setFormat("{point.id}")
				.setColor(new Color("#000000"))
				.getStyle().setTextOutline("false");	// its a string in hc api but still works like this
		
		SeriesTilemap seriesTilemap = new SeriesTilemap();
		seriesTilemap.setName("");
		seriesTilemap.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesTilemap);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setId("AL").setName("Alabama").setClassName("South").setX(6).setY(7).setValue(4849377));
		array.add(new Data().setId("AK").setName("Alaska").setClassName("West").setX(0).setY(0).setValue(737732));
		array.add(new Data().setId("AZ").setName("Arizona").setClassName("West").setX(5).setY(3).setValue(6745408));
		array.add(new Data().setId("AR").setName("Arkansas").setClassName("South").setX(5).setY(6).setValue(2994079));
		array.add(new Data().setId("CA").setName("California").setClassName("West").setX(5).setY(2).setValue(39250017));
		array.add(new Data().setId("CO").setName("Colorado").setClassName("West").setX(4).setY(3).setValue(5540545));
		array.add(new Data().setId("CT").setName("Connecticut").setClassName("Northeast").setX(3).setY(11).setValue(3596677));
		array.add(new Data().setId("DE").setName("Delaware").setClassName("South").setX(4).setY(9).setValue(935614));
		array.add(new Data().setId("DC").setName("District of Columbia").setClassName("South").setX(4).setY(10).setValue(7288000));
		array.add(new Data().setId("FL").setName("Florida").setClassName("South").setX(8).setY(8).setValue(20612439));
		array.add(new Data().setId("GA").setName("Georgia").setClassName("South").setX(7).setY(8).setValue(10310371));
		array.add(new Data().setId("HI").setName("Hawaii").setClassName("West").setX(8).setY(0).setValue(1419561));
		array.add(new Data().setId("ID").setName("Idaho").setClassName("West").setX(3).setY(2).setValue(1634464));
		array.add(new Data().setId("IL").setName("Illinois").setClassName("Midwest").setX(3).setY(6).setValue(12801539));
		array.add(new Data().setId("IN").setName("Indiana").setClassName("Midwest").setX(3).setY(7).setValue(6596855));
		array.add(new Data().setId("IA").setName("Iowa").setClassName("Midwest").setX(3).setY(5).setValue(3107126));
		array.add(new Data().setId("KS").setName("Kansas").setClassName("Midwest").setX(5).setY(5).setValue(2904021));
		array.add(new Data().setId("KY").setName("Kentucky").setClassName("South").setX(4).setY(6).setValue(4413457));
		array.add(new Data().setId("LA").setName("Louisiana").setClassName("South").setX(6).setY(5).setValue(4649676));
		array.add(new Data().setId("ME").setName("Maine").setClassName("Northeast").setX(0).setY(11).setValue(1330089));
		array.add(new Data().setId("MD").setName("Maryland").setClassName("South").setX(4).setY(8).setValue(6016447));
		array.add(new Data().setId("MA").setName("Massachusetts").setClassName("Northeast").setX(2).setY(10).setValue(6811779));
		array.add(new Data().setId("MI").setName("Michigan").setClassName("Midwest").setX(2).setY(7).setValue(9928301));
		array.add(new Data().setId("MN").setName("Minnesota").setClassName("Midwest").setX(2).setY(4).setValue(5519952));
		array.add(new Data().setId("MS").setName("Mississippi").setClassName("South").setX(6).setY(6).setValue(2984926));
		array.add(new Data().setId("MO").setName("Missouri").setClassName("Midwest").setX(4).setY(5).setValue(6093000));
		array.add(new Data().setId("MT").setName("Montana").setClassName("West").setX(2).setY(2).setValue(1023579));
		array.add(new Data().setId("NE").setName("Nebraska").setClassName("Midwest").setX(4).setY(4).setValue(1881503));
		array.add(new Data().setId("NV").setName("Nevada").setClassName("West").setX(4).setY(2).setValue(2839099));
		array.add(new Data().setId("NH").setName("New Hampshire").setClassName("Northeast").setX(1).setY(11).setValue(1326813));
		array.add(new Data().setId("NJ").setName("New Jersey").setClassName("Northeast").setX(3).setY(10).setValue(8944469));
		array.add(new Data().setId("NM").setName("New Mexico").setClassName("West").setX(6).setY(3).setValue(2085572));
		array.add(new Data().setId("NY").setName("New York").setClassName("Northeast").setX(2).setY(9).setValue(19745289));
		array.add(new Data().setId("NC").setName("North Carolina").setClassName("South").setX(5).setY(9).setValue(10146788));
		array.add(new Data().setId("ND").setName("North Dakota").setClassName("Midwest").setX(2).setY(3).setValue(739482));
		array.add(new Data().setId("OH").setName("Ohio").setClassName("Midwest").setX(3).setY(8).setValue(11614373));
		array.add(new Data().setId("OK").setName("Oklahoma").setClassName("South").setX(6).setY(4).setValue(3878051));
		array.add(new Data().setId("OR").setName("Oregon").setClassName("West").setX(4).setY(1).setValue(3970239));
		array.add(new Data().setId("PA").setName("Pennsylvania").setClassName("Northeast").setX(3).setY(9).setValue(12784227));
		array.add(new Data().setId("RI").setName("Rhode Island").setClassName("Northeast").setX(2).setY(11).setValue(1055173));
		array.add(new Data().setId("SC").setName("South Carolina").setClassName("South").setX(6).setY(8).setValue(4832482));
		array.add(new Data().setId("SD").setName("South Dakota").setClassName("Midwest").setX(3).setY(4).setValue(853175));
		array.add(new Data().setId("TN").setName("Tennessee").setClassName("South").setX(5).setY(7).setValue(6651194));
		array.add(new Data().setId("TX").setName("Texas").setClassName("South").setX(7).setY(4).setValue(27862596));
		array.add(new Data().setId("UT").setName("Utah").setClassName("West").setX(5).setY(4).setValue(2942902));
		array.add(new Data().setId("VT").setName("Vermont").setClassName("Northeast").setX(1).setY(10).setValue(626011));
		array.add(new Data().setId("VA").setName("Virginia").setClassName("South").setX(5).setY(8).setValue(8411808));
		array.add(new Data().setId("WA").setName("Washington").setClassName("West").setX(2).setY(1).setValue(7288000));
		array.add(new Data().setId("WV").setName("West Virginia").setClassName("South").setX(4).setY(7).setValue(1850326));
		array.add(new Data().setId("WI").setName("Wisconsin").setClassName("Midwest").setX(2).setY(5).setValue(5778708));
		array.add(new Data().setId("WY").setName("Wyoming").setClassName("West").setX(3).setY(3).setValue(584153));

    	return array;
    }
	
}
