package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.RadialGradient;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesScatter3d;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDScatterChart extends DemoChartBase {
	private static final long serialVersionUID = -987490334235488228L;
	
	/**
	 * 
	 */
	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.SCATTER3D)
			.setMarginBottom(100)
			.getOptions3d().setEnabled(true)
				.setAlpha(10)
				.setBeta(30)
				.setDepth(250)
				.setViewDistance(5)
				.setFitToPlot(false);
		chartOptions.getChart().getOptions3d().getFrame().getBottom().setSize(1).setColor(new Color().setRGBA(0, 0, 0, 0.02));
		chartOptions.getChart().getOptions3d().getFrame().getBack().setSize(1).setColor(new Color().setRGBA(0, 0, 0, 0.04));
		chartOptions.getChart().getOptions3d().getFrame().getSide().setSize(1).setColor(new Color().setRGBA(0, 0, 0, 0.06));
		
		chartOptions.getTitle().setText("Scatter Box");
		
		chartOptions.getPlotOptions().getScatter3d().setWidth(10).setHeight(10).setDepth(10);

		chartOptions.getXAxisSingle()
			.setMin(0)
			.setMax(10)
			.setTitle(null);
			
		chartOptions.getYAxisSingle()
			.setMin(0)
			.setMax(10)
			.setGridLineWidth(1);
		
		chartOptions.getZAxisSingle()
			.setMin(0)
			.setMax(10)
			.setShowFirstLabel(false);
		
		chartOptions.getLegend().setEnabled(false);
		
		SeriesScatter3d seriesScatter3d = new SeriesScatter3d();
		seriesScatter3d.setName("Reading").setColorByPoint(true);
		seriesScatter3d.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesScatter3d);
		
		// Create new colors list
		List<Color> newColors = new ArrayList<Color>();
		
		for (Color defaultColor : chartOptions.getColors()) {
			ArrayList<Stop> stops = new ArrayList<Stop>();
			stops.add(new Stop(0, new Color(defaultColor.getColor())));
			stops.add(new Stop(1, new Color(defaultColor.getColor()).brighten(-0.2)));
			
			newColors.add(new Color(new RadialGradient(0.4,  0.3, 0.5), stops));
		}
		
		chartOptions.setColors(newColors);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		array.add(Arrays.asList(1, 6, 5));
		array.add(Arrays.asList(8, 7, 9));
		array.add(Arrays.asList(1, 3, 4));
		array.add(Arrays.asList(4, 6, 8));
		array.add(Arrays.asList(5, 7, 7));
		array.add(Arrays.asList(6, 9, 6));
		array.add(Arrays.asList(7, 0, 5));
		array.add(Arrays.asList(2, 3, 3));
		array.add(Arrays.asList(3, 9, 8));
		array.add(Arrays.asList(3, 6, 5));
		array.add(Arrays.asList(4, 9, 4));
		array.add(Arrays.asList(2, 3, 3));
		array.add(Arrays.asList(6, 9, 9));
		array.add(Arrays.asList(0, 7, 0));
		array.add(Arrays.asList(7, 7, 9));
		array.add(Arrays.asList(7, 2, 9));
		array.add(Arrays.asList(0, 6, 2));
		array.add(Arrays.asList(4, 6, 7));
		array.add(Arrays.asList(3, 7, 7));
		array.add(Arrays.asList(0, 1, 7));
		array.add(Arrays.asList(2, 8, 6));
		array.add(Arrays.asList(2, 3, 7));
		array.add(Arrays.asList(6, 4, 8));
		array.add(Arrays.asList(3, 5, 9));
		array.add(Arrays.asList(7, 9, 5));
		array.add(Arrays.asList(3, 1, 7));
		array.add(Arrays.asList(4, 4, 2));
		array.add(Arrays.asList(3, 6, 2));
		array.add(Arrays.asList(3, 1, 6));
		array.add(Arrays.asList(6, 8, 5));
		array.add(Arrays.asList(6, 6, 7));
		array.add(Arrays.asList(4, 1, 1));
		array.add(Arrays.asList(7, 2, 7));
		array.add(Arrays.asList(7, 7, 0));
		array.add(Arrays.asList(8, 8, 9));
		array.add(Arrays.asList(9, 4, 1));
		array.add(Arrays.asList(8, 3, 4));
		array.add(Arrays.asList(9, 8, 9));
		array.add(Arrays.asList(3, 5, 3));
		array.add(Arrays.asList(0, 2, 4));
		array.add(Arrays.asList(6, 0, 2));
		array.add(Arrays.asList(2, 1, 3));
		array.add(Arrays.asList(5, 8, 9));
		array.add(Arrays.asList(2, 1, 1));
		array.add(Arrays.asList(9, 7, 6));
		array.add(Arrays.asList(3, 0, 2));
		array.add(Arrays.asList(9, 9, 0));
		array.add(Arrays.asList(3, 4, 8));
		array.add(Arrays.asList(2, 6, 1));
		array.add(Arrays.asList(8, 9, 2));
		array.add(Arrays.asList(7, 6, 5));
		array.add(Arrays.asList(6, 3, 1));
		array.add(Arrays.asList(9, 3, 1));
		array.add(Arrays.asList(8, 9, 3));
		array.add(Arrays.asList(9, 1, 0));
		array.add(Arrays.asList(3, 8, 7));
		array.add(Arrays.asList(8, 0, 0));
		array.add(Arrays.asList(4, 9, 7));
		array.add(Arrays.asList(8, 6, 2));
		array.add(Arrays.asList(4, 3, 0));
		array.add(Arrays.asList(2, 3, 5));
		array.add(Arrays.asList(9, 1, 4));
		array.add(Arrays.asList(1, 1, 4));
		array.add(Arrays.asList(6, 0, 2));
		array.add(Arrays.asList(6, 1, 6));
		array.add(Arrays.asList(3, 8, 8));
		array.add(Arrays.asList(8, 8, 7));
		array.add(Arrays.asList(5, 5, 0));
		array.add(Arrays.asList(3, 9, 6));
		array.add(Arrays.asList(5, 4, 3));
		array.add(Arrays.asList(6, 8, 3));
		array.add(Arrays.asList(0, 1, 5));
		array.add(Arrays.asList(6, 7, 3));
		array.add(Arrays.asList(8, 3, 2));
		array.add(Arrays.asList(3, 8, 3));
		array.add(Arrays.asList(2, 1, 6));
		array.add(Arrays.asList(4, 6, 7));
		array.add(Arrays.asList(8, 9, 9));
		array.add(Arrays.asList(5, 4, 2));
		array.add(Arrays.asList(6, 1, 3));
		array.add(Arrays.asList(6, 9, 5));
		array.add(Arrays.asList(4, 8, 2));
		array.add(Arrays.asList(9, 7, 4));
		array.add(Arrays.asList(5, 4, 2));
		array.add(Arrays.asList(9, 6, 1));
		array.add(Arrays.asList(2, 7, 3));
		array.add(Arrays.asList(4, 5, 4));
		array.add(Arrays.asList(6, 8, 1));
		array.add(Arrays.asList(3, 4, 0));
		array.add(Arrays.asList(2, 2, 6));
		array.add(Arrays.asList(5, 1, 2));
		array.add(Arrays.asList(9, 9, 7));
		array.add(Arrays.asList(6, 9, 9));
		array.add(Arrays.asList(8, 4, 3));
		array.add(Arrays.asList(4, 1, 7));
		array.add(Arrays.asList(6, 2, 5));
		array.add(Arrays.asList(0, 4, 9));
		array.add(Arrays.asList(3, 5, 9));
		array.add(Arrays.asList(6, 9, 1));
		array.add(Arrays.asList(1, 9, 2));

    	return array;
    }
	
}
