package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesPyramid3d;
import com.hyjavacharts.model.highcharts.series.seriespyramid3d.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDPyramidChart extends DemoChartBase {
	private static final long serialVersionUID = 7926076687802379216L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart()
			.setType(ChartType.PYRAMID3D)
			.getOptions3d().setEnabled(true).setAlpha(10).setDepth(50).setViewDistance(50);
		
		chartOptions.getTitle().setText("Highcharts Pyramid3D Chart");
		
		chartOptions.getPlotOptions()
			.getPyramid3d()
				.setWidthAsString("60%")
				.setHeightAsString("80%")
				.setCenterAsArrayString(Arrays.asList("50%", "45%"))
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b> ({point.y:,.0f})")
					.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"))
					.setAllowOverlap(true)
					.setX(10)
					.setY(-5);
		
		SeriesPyramid3d seriesPyramid3d = new SeriesPyramid3d();
		seriesPyramid3d.setName("Unique users");
		seriesPyramid3d.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPyramid3d);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Website visits").setY(15654));
		array.add(new Data().setName("Downloads").setY(4064));
		array.add(new Data().setName("Requested price list").setY(1987));
		array.add(new Data().setName("Invoice sent").setY(976));
		array.add(new Data().setName("Finalized").setY(846));

    	return array;
    }
	
}
