package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDDonut extends DemoChartBase {
	private static final long serialVersionUID = 6651349589314935510L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.PIE)
			.getOptions3d()
				.setEnabled(true)
				.setAlpha(45);
		
		chartOptions.getTitle().setText("Contents of Highsoft's weekly fruit delivery");
		chartOptions.getSubtitle().setText("3D donut in Highcharts");
		
		chartOptions.getPlotOptions().getPie()
			.setInnerSizeAsNumber(100)
			.setDepth(45);
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setType(SeriesType.PIE).setName("Delivered amount");
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Bananas").setY(8));
		array.add(new Data().setName("Kiwi").setY(3));
		array.add(new Data().setName("Mixed nuts").setY(1));
		array.add(new Data().setName("Oranges").setY(6));
		array.add(new Data().setName("Apples").setY(8));
		array.add(new Data().setName("Pears").setY(4));
		array.add(new Data().setName("Clementines").setY(4));
		array.add(new Data().setName("Reddish (bag)").setY(1));
		array.add(new Data().setName("Grapes (bunch)").setY(1));
		
		return array;
    }
}
