package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesCylinder;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDCylinderChart extends DemoChartBase {
	private static final long serialVersionUID = -396822876102924779L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart()
			.setType(ChartType.CYLINDER)
			.getOptions3d().setEnabled(true).setAlpha(15).setBeta(15).setDepth(50).setViewDistance(25);
		
		chartOptions.getTitle().setText("Highcharts Cylinder Chart");
		
		chartOptions.getPlotOptions()
			.getCylinder().setDepth(25).setColorByPoint(true);
		
		SeriesCylinder seriesCylinder = new SeriesCylinder();
		seriesCylinder.setName("Cylinders").setShowInLegend(false);
		seriesCylinder.setDataAsArrayNumber(
			Arrays.asList(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesCylinder);
		
		return highChart;
	}
	
}
