package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDColumnWithNullAndZeros extends DemoChartBase {
	private static final long serialVersionUID = 3052090133720071667L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("3D chart with null values");
		chartOptions.getSubtitle().setText("Notice the difference between a 0 value and a null point");
		
		chartOptions.getChart().getOptions3d()
			.setEnabled(true)
			.setAlpha(10)
			.setBeta(25)
			.setDepth(70);
		
		chartOptions.getPlotOptions().getColumn().setDepth(25);
		
		XAxis xAxis = new XAxis();
		xAxis.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
		xAxis.getLabels().setSkew3d(true).getStyle().setFontSize("16px");
		chartOptions.getXAxis().add(xAxis);
		
		YAxis yAxis = new YAxis();
		yAxis.setMin(0).getTitle().setText(null);
		chartOptions.getYAxis().add(yAxis);

		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Sales")
			.setDataAsArrayNumber(Arrays.asList(2, 3, null, 4, 0, 5, 1, 4, 6, 3));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}

}
