package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesBubble;
import com.hyjavacharts.model.highcharts.series.seriesbubble.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ThreeDBubbles extends DemoChartBase {
	private static final long serialVersionUID = 8424710899961865334L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BUBBLE)
			.setPlotBorderWidth(1)
			.setZoomType(ZoomType.XY);
		
		chartOptions.getTitle().setText("Highcharts bubbles with radial gradient fill");
		
		chartOptions.getXAxisSingle().setGridLineWidth(1);
		chartOptions.getYAxisSingle().setStartOnTick(false).setEndOnTick(false);
		
		SeriesBubble seriesBubble = new SeriesBubble();
		
		ArrayList<Stop> stops = new ArrayList<Stop>();
		stops.add(new Stop(0, new Color().setRGBA(255, 255, 255, 0.5)));
		stops.add(new Stop(1, new Color().setColorValue("Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0.5).get('rgba')")));
		
		seriesBubble.getMarker().getFillColor().setStops(stops).getRadialGradient().setCx(0.4).setCy(0.3).setR(0.7);
		seriesBubble.setDataAsArrayObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesBubble);
		
		seriesBubble = new SeriesBubble();
		
		stops = new ArrayList<Stop>();
		stops.add(new Stop(0, new Color().setRGBA(255, 255, 255, 0.5)));
		stops.add(new Stop(1, new Color().setColorValue("Highcharts.Color(Highcharts.getOptions().colors[1]).setOpacity(0.5).get('rgba')")));

		seriesBubble.getMarker().getFillColor().setStops(stops).getRadialGradient().setCx(0.4).setCy(0.3).setR(0.7);
		seriesBubble.setDataAsArrayObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesBubble);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesData(int series) {
		ArrayList<Data> array = new ArrayList<Data>();
		
		if (series == 1) {
			array.add(new Data().setX(9).setY(81).setZ(63));
	        array.add(new Data().setX(98).setY(5).setZ(89));
	        array.add(new Data().setX(51).setY(50).setZ(73));
	        array.add(new Data().setX(41).setY(22).setZ(14));
	        array.add(new Data().setX(58).setY(24).setZ(20));
	        array.add(new Data().setX(78).setY(37).setZ(34));
	        array.add(new Data().setX(55).setY(56).setZ(53));
	        array.add(new Data().setX(18).setY(45).setZ(70));
	        array.add(new Data().setX(42).setY(44).setZ(28));
	        array.add(new Data().setX(3).setY(52).setZ(59));
	        array.add(new Data().setX(31).setY(18).setZ(97));
	        array.add(new Data().setX(79).setY(91).setZ(63));
	        array.add(new Data().setX(93).setY(23).setZ(23));
	        array.add(new Data().setX(44).setY(83).setZ(22));
		}
		
		if (series == 2) {
			array.add(new Data().setX(42).setY(38).setZ(20));
            array.add(new Data().setX(6).setY(18).setZ(1));
            array.add(new Data().setX(1).setY(93).setZ(55));
            array.add(new Data().setX(57).setY(2).setZ(90));
            array.add(new Data().setX(80).setY(76).setZ(22));
            array.add(new Data().setX(11).setY(74).setZ(96));
            array.add(new Data().setX(88).setY(56).setZ(10));
            array.add(new Data().setX(30).setY(47).setZ(49));
            array.add(new Data().setX(57).setY(62).setZ(98));
            array.add(new Data().setX(4).setY(16).setZ(16));
            array.add(new Data().setX(46).setY(10).setZ(11));
            array.add(new Data().setX(22).setY(87).setZ(89));
            array.add(new Data().setX(57).setY(91).setZ(82));
            array.add(new Data().setX(45).setY(15).setZ(98));
		}

    	return array;
    }
}
