package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import javax.ws.rs.client.WebTarget;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.constants.Key;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesSunburst;
import com.hyjavacharts.model.highcharts.series.seriessunburst.Data;
import com.hyjavacharts.model.highcharts.series.seriessunburst.Levels;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class Sunburst extends DemoChartBase {
	private static final long serialVersionUID = 3368802609814325629L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getColors().add(0, new Color("transparent"));
		
		chartOptions.getTitle().setText("World population 2017");
		chartOptions.getSubtitle().setText("Source <href=\"https://en.wikipedia.org/wiki/List_of_countries_by_population_(United_Nations)\">Wikipedia</a>");

		chartOptions.getTooltip().setHeaderFormat("").setPointFormat("The population of <b>{point.name}</b> is <b>{point.value}</b>");

		SeriesSunburst seriesSunburst = new SeriesSunburst();
		seriesSunburst.setType(SeriesType.SUNBURST)
			.setAllowDrillToNode(true)
			.setCursor(Cursor.POINTER)
			.getDataLabels().setFormat("{point.name}").getFilter().setProperty("innerArcLength").setOperator(">").setValue(16);
		
		Levels lev = new Levels();
		lev.setLevel(1).setLevelIsConstant(false);
		lev.getDataLabels().setRotationMode("parallel")
							.getFilter().setProperty("outerArcLength").setOperator(">").setValue(64);
		seriesSunburst.getLevels().add(lev);
		
		lev = new Levels();
		lev.setLevel(2).setColorByPoint(true);
		lev.getDataLabels().setRotationMode("parallel");
		seriesSunburst.getLevels().add(lev);
		
		lev = new Levels();
		lev.setLevel(3);
		lev.getColorVariation().setKey(Key.BRIGHTNESS).setTo(-0.5);
		seriesSunburst.getLevels().add(lev);
		
		lev = new Levels();
		lev.setLevel(4);
		lev.getColorVariation().setKey(Key.BRIGHTNESS).setTo(0.5);
		seriesSunburst.getLevels().add(lev);
		
		seriesSunburst.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesSunburst);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		// REST service returns CSV data in format parent, name, id, value
		WebTarget webTarget = new RestService().getWebTarget();
		String heatMapData = webTarget.path("SunburstCSVData").request().get(String.class);

		String[] dataRows = heatMapData.split("\n");
		
		for(int i = 1; i < dataRows.length; i++) {
			String[] rowElements = dataRows[i].split(",");

			if (rowElements.length == 4) {
				array.add(new Data().setParent(rowElements[0]).setName(rowElements[1]).setId(rowElements[2]).setValue(Integer.parseInt(rowElements[3])));
			}
			else {
				array.add(new Data().setParent(rowElements[0]).setName(rowElements[1]).setId(rowElements[2]));
			}
		}

    	return array;
    }

}
