package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class StackedPercentageColumn extends DemoChartBase {
	private static final long serialVersionUID = -3755171931043450073L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Stacked column chart");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setAllowDecimals(false)
			.setMin(0)
			.getTitle().setText("Total fruit consumption");
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip()
			.setPointFormat("<span style=\"color:{series.color}\">{series.name}</span>: <b>{point.y}</b> ({point.percentage:.0f}%)<br/>")
			.setShared(true);
		
		chartOptions.getPlotOptions().getColumn()
			.setStacking(Stacking.PERCENT);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("John").setStackAsString("male");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Jane").setStackAsString("female");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(2, 2, 3, 2, 1));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Joe").setStackAsString("male");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 4, 4, 2, 5));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}
	
}
