package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Stacking;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class StackedColumn extends DemoChartBase {
	private static final long serialVersionUID = -7441956048433661831L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Stacked column chart");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Apples", "Oranges", "Pears", "Grapes", "Bananas"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setMin(0).getTitle().setText("Total fruit consumption");
		yAxi.getStackLabels()
			.setEnabled(true)
			.getStyle()
				.setFontWeight("bold")
				.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.textColor) || 'gray'")); 
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getLegend()
			.setAlign(HorizontalAlign.RIGHT)
			.setX(-30)
			.setVerticalAlign(VerticalAlign.TOP)
			.setY(25)
			.setFloating(true)
			.setBackgroundColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.background2) || 'white'"))
			.setBorderColor(new Color("#CCC"))
			.setBorderWidth(1)
			.setShadowAsBoolean(false);
		
		chartOptions.getTooltip()
			.setHeaderFormat("<b>{point.x}</b><br/>")
			.setPointFormat("{series.name}: {point.y}<br/>Total: {point.stackTotal}");
		
		chartOptions.getPlotOptions().getColumn()
			.setStacking(Stacking.NORMAL)
			.getDataLabels()
				.setEnabled(true)
				.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'"));
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("John");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(5, 3, 4, 7, 2));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Jane");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(2, 2, 3, 2, 1));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Joe");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(3, 4, 4, 2, 5));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}
	
}
