package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Symbol;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.hyjavacharts.model.highcharts.series.seriesspline.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class SplineWithSymbols extends DemoChartBase {
	private static final long serialVersionUID = -4361277024432968773L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.SPLINE);
		chartOptions.getTitle().setText("Monthly Average Temperature");
		chartOptions.getSubtitle().setText("Source: WorldClimate.com");

		XAxis xAxi = new XAxis();
		xAxi.setCrosshairAsBoolean(true).setCategories(
			Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Temperature");
		yAxi.getLabels().getFormatter().setFunctionBody("return this.value + '°';");
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getTooltip().setShared(true);
		chartOptions.getPlotOptions().getSpline().getMarker().setRadius(4).setLineColor(new Color("#666666")).setLineWidth(1);
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setName("Tokyo").getMarker().setSymbolAsEnum(Symbol.SQUARE);
		seriesSpline.setDataAsArrayObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesSpline);
		
		seriesSpline = new SeriesSpline();
		seriesSpline.setName("London").getMarker().setSymbolAsEnum(Symbol.DIAMOND);
		seriesSpline.setDataAsArrayObject(getSeriesData(2));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesData(int series) {
		ArrayList<Data> array = new ArrayList<Data>();
		
		if (series == 1) {
			Data d = new Data();
			d.setY(26.5);
			d.getMarker().setSymbolAsString("url(https://www.hyjavacharts.com/content/images/sun.png)");
			
			array.add(new Data().setY(7.0));
			array.add(new Data().setY(6.9));
			array.add(new Data().setY(9.5));
			array.add(new Data().setY(14.5));
			array.add(new Data().setY(18.2));
			array.add(new Data().setY(21.5));
			array.add(new Data().setY(25.2));
			array.add(d);
			array.add(new Data().setY(23.3));
			array.add(new Data().setY(18.3));
			array.add(new Data().setY(13.9));
			array.add(new Data().setY(9.6));
		}
		else {
			Data d = new Data();
			d.setY(3.9);
			d.getMarker().setSymbolAsString("url(https://www.hyjavacharts.com/content/images/snow.png)");
			
			array.add(d);
			array.add(new Data().setY(4.2));
			array.add(new Data().setY(5.7));
			array.add(new Data().setY(8.5));
			array.add(new Data().setY(11.9));
			array.add(new Data().setY(15.2));
			array.add(new Data().setY(17.0));
			array.add(new Data().setY(16.6));
			array.add(new Data().setY(14.2));
			array.add(new Data().setY(10.3));
			array.add(new Data().setY(6.6));
			array.add(new Data().setY(4.8));
		}
		
    	return array;
    }
}
