package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.hyjavacharts.model.highcharts.series.seriesspline.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class SplineWithInvertedAxis extends DemoChartBase {
	private static final long serialVersionUID = 3898914060609659894L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();

		chartOptions.getChart().setType(ChartType.SPLINE).setInverted(true);
		chartOptions.getTitle().setText("Atmosphere Temperature by Altitude");
		chartOptions.getSubtitle().setText("According to the Standard Atmosphere Model");

		XAxis xAxi = new XAxis();
		xAxi.setReversed(false).getTitle().setText("Altitude");
		xAxi.getLabels().getFormatter().setFunctionBody("return this.value + 'km';");
		xAxi.setMaxPadding(0.05).setShowLastLabel(true);
		chartOptions.getXAxis().add(xAxi);
	
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Temperature");
		yAxi.setLineWidth(2).getLabels().getFormatter().setFunctionBody("return this.value + '°';");
		chartOptions.getYAxis().add(yAxi);
	
		chartOptions.getLegend().setEnabled(false);
		chartOptions.getTooltip().setHeaderFormat("<b>{series.name}</b><br/>").setPointFormat("{point.x} km: {point.y}°C");
		
		chartOptions.getPlotOptions().getSpline().getMarker().setEnabled(true);
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setName("Temperature");
		seriesSpline.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setX(0).setY(15));
		array.add(new Data().setX(10).setY(-50));
		array.add(new Data().setX(20).setY(-56.5));
		array.add(new Data().setX(30).setY(-46.5));
		array.add(new Data().setX(40).setY(-22.1));
		array.add(new Data().setX(50).setY(-2.5));
		array.add(new Data().setX(60).setY(-27.7));
		array.add(new Data().setX(70).setY(-55.7));
		array.add(new Data().setX(80).setY(-76.5));

    	return array;
    }
}
