package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.Shape;
import com.hyjavacharts.model.highcharts.pane.Background;
import com.hyjavacharts.model.highcharts.series.SeriesSolidgauge;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class SolidGauge extends DemoChartBase {
	private static final long serialVersionUID = -7420400437404494787L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.SOLIDGAUGE);
		chartOptions.getTitle().setText(null);
		chartOptions.getPaneSingle().getCenterAsArrayString().add("50%");
		chartOptions.getPaneSingle().getCenterAsArrayString().add("85%");
		chartOptions.getPaneSingle().setSizeAsString("140%").setStartAngle(-90).setEndAngle(90);
		chartOptions.getTooltip().setEnabled(false);
		
		Background b = new Background()
			.setInnerRadiusAsString("60%")
			.setOuterRadiusAsString("100%")
			.setShape(Shape.ARC)
			.setBackgroundColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.background2) || '#EEE'"));
		chartOptions.getPaneSingle().getBackground().add(b);
		
		YAxis yAxis = new YAxis();
		yAxis.setLineWidth(0).setTickAmount(2).setMin(0).setMax(200).getTitle().setText("Speed").setY(-70); 	
		yAxis.setMinorTickIntervalAsNumber(null);
		yAxis.getLabels().setY(16);
		yAxis.getStops().add(new Stop(0.1, new Color("#55BF3B")));
		yAxis.getStops().add(new Stop(0.5, new Color("#DDDF0D")));
		yAxis.getStops().add(new Stop(0.9, new Color("#DF5353")));
		chartOptions.getYAxis().add(yAxis);
		
		chartOptions.getPlotOptions().getSolidgauge().getDataLabels()
			.setY(5)
			.setBorderWidth(0)
			.setUseHTML(true);
		
		chartOptions.getCredits().setEnabled(false);
		
		String format = "<div style=\"text-align:center\"><span style=\"font-size:25px;color:" 
				+ "((Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black') + '\">{y}</span><br/>"
				+ "<span style=\"font-size:12px;color:silver\">km/h</span></div>";
		
		SeriesSolidgauge seriesSolidgauge = new SeriesSolidgauge();
		seriesSolidgauge
			.setType(SeriesType.SOLIDGAUGE)
			.setName("Speed")
			.getDataLabels().setFormat(format);
		seriesSolidgauge.setDataAsArrayNumber(new ArrayList<Number>(Arrays.asList(80)));
		chartOptions.getSeries().add(seriesSolidgauge);
		
		chartOptions.getData().setCsvURL(RestService.getURI() + "/GaugeSpeedCSVData")
			.setEnablePolling(true)
			.setDataRefreshRate(3);
		
		return highChart;
	}

}
