package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.plotoptions.series.Zones;
import com.hyjavacharts.model.highcharts.yaxis.PlotBands;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class ServerMonitoring extends DemoChartBase {
	private static final long serialVersionUID = 4576831292152423040L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.BAR);

		chartOptions.getTitle().setText("Server Monitoring Demo");
		chartOptions.getSubtitle().setText("Instance Load");
		chartOptions.getLegend().setEnabled(false);

		chartOptions.getData().setCsvURL(RestService.getURI() + "/ServerMonitoringCSVData")
			.setEnablePolling(true)
			.setDataRefreshRate(1);
		
		chartOptions.getPlotOptions().getBar().setColorByPoint(true);
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#4CAF50")).setValue(0));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#8BC34A")).setValue(10));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#CDDC39")).setValue(20));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#CDDC39")).setValue(30));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#FFEB3B")).setValue(40));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#FFEB3B")).setValue(50));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#FFC107")).setValue(60));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#FF9800")).setValue(70));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#FF5722")).setValue(80));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#F44336")).setValue(90));
		chartOptions.getPlotOptions().getSeries().getZones().add(new Zones().setColor(new Color("#F44336")).setValue(10000));
		
		chartOptions.getPlotOptions().getSeries().getDataLabels().setEnabled(true).setFormat("{point.y:.0f}%");
		
		chartOptions.getTooltip().setValueDecimals(1).setValueSuffix("%");
		
		chartOptions.getXAxisSingle().setType(AxisType.CATEGORY)
			.getLabels().getStyle().setFontSize("10px");
		
		chartOptions.getYAxisSingle().setMax(100).setTitle(null);
		chartOptions.getYAxisSingle().getPlotBands().add(new PlotBands().setFrom(0).setTo(30).setColor(new Color("#E8F5E9")));
		chartOptions.getYAxisSingle().getPlotBands().add(new PlotBands().setFrom(30).setTo(70).setColor(new Color("#FFFDE7")));
		chartOptions.getYAxisSingle().getPlotBands().add(new PlotBands().setFrom(70).setTo(100).setColor(new Color("#FFEBEE")));
		
		return highChart;
	}
	
}
