package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class SemiCircleDonut extends DemoChartBase {
	private static final long serialVersionUID = 915051807111750042L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart()
			.setPlotBackgroundColor(null)
			.setPlotBorderWidth(0)
			.setPlotShadowAsBoolean(false);
		
		chartOptions.getTitle().setText("Browser<br>shares<br>2017")
			.setAlign(HorizontalAlign.CENTER)
			.setVerticalAlign(VerticalAlign.MIDDLE)
			.setY(40);

		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions()
			.getPie()
				.setStartAngle(-90)
				.setEndAngle(90)
				.setCenterAsArrayString(Arrays.asList("50%", "75%"))
				.getDataLabels()
					.setEnabled(true)
					.setDistance(-50)
					.getStyle()
						.setFontWeight("bold")
						.setColor(new Color("white"));
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setType(SeriesType.PIE)
			.setName("Browser share")
			.setInnerSizeAsString("50%");
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Chrome").setY(58.9));
		array.add(new Data().setName("Firefox").setY(13.29));
		array.add(new Data().setName("Internet Explorer").setY(13));
		array.add(new Data().setName("Edge").setY(3.78));
		array.add(new Data().setName("Safari").setY(3.42));
		Data d = new Data();
		d.setName("Other")
			.setY(7.61)
			.getDataLabels()
				.setEnabled(false);
		array.add(d);
		
		return array;
    }
}
