package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesPolygon;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.PolygonSeriesData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PolygonSeries extends DemoChartBase {
	private static final long serialVersionUID = -7594270178072639949L;

	public Highchart configure() {
		Highchart highChart = new Highchart(); 
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Height vs Weight");
		chartOptions.getSubtitle().setText("Polygon series in Highcharts");
		
		chartOptions.getXAxisSingle()
			.setGridLineWidth(1)
			.setStartOnTick(true)
			.setEndOnTick(true)
			.setShowLastLabel(true)
			.getTitle().setText("Height (cm)");		

		chartOptions.getYAxisSingle().getTitle().setText("Weight (kg)");

		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.MIDDLE);

		chartOptions.getTooltip()
			.setHeaderFormat("<b>{series.name}</b><br>")
			.setPointFormat("{point.x} cm, {point.y} kg");
		
		PolygonSeriesData seriesData = new PolygonSeriesData();
		
		SeriesPolygon seriesPolygon = new SeriesPolygon();
		seriesPolygon.setType(SeriesType.POLYGON).setName("Target");
		seriesPolygon.setDataAsArrayJavaObject(seriesData.getSeriesData(1));
		chartOptions.getSeries().add(seriesPolygon);
		
		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setType(SeriesType.SCATTER).setName("Observations");
		seriesScatter.setDataAsArrayJavaObject(seriesData.getSeriesData(2));
		chartOptions.getSeries().add(seriesScatter);
		
		return highChart;
	}

}
