package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.PointPlacement;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PolarChart extends DemoChartBase {
	private static final long serialVersionUID = -7698719325938004218L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setPolar(true);
		chartOptions.getTitle().setText("Highcharts Polar Chart");
		
		chartOptions.getPaneSingle().setStartAngle(0).setEndAngle(360);
		
		chartOptions.getXAxisSingle()
			.setTickInterval(45)
			.setMin(0)
			.setMax(360)
			.getLabels().getFormatter().setFunctionBody("return this.value + '°';");
		
		chartOptions.getYAxisSingle().setMin(0);

		chartOptions.getPlotOptions().getSeries().setPointStart(0).setPointInterval(45);
		chartOptions.getPlotOptions().getColumn().setPointPadding(0).setGroupPadding(0);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN)
			.setName("Column")
			.setPointPlacementAsEnum(PointPlacement.BETWEEN);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(8, 7, 6, 5, 4, 3, 2, 1));
		chartOptions.getSeries().add(seriesColumn);
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setType(SeriesType.LINE)
			.setName("Line");
		seriesLine.setDataAsArrayNumber(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8));
		chartOptions.getSeries().add(seriesLine);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setType(SeriesType.AREA)
			.setName("Area");
		seriesArea.setDataAsArrayNumber(Arrays.asList(1, 8, 2, 7, 3, 6, 4, 5));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}

}
