package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.List;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.RadialGradient;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.Cursor;
import com.hyjavacharts.model.highcharts.series.SeriesPie;
import com.hyjavacharts.model.highcharts.series.seriespie.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PieWithGradientFill extends DemoChartBase {
	private static final long serialVersionUID = 8572498890977753269L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.PIE)
			.setPlotShadowAsBoolean(false);
		chartOptions.getTitle().setText("Browser market shares in January, 2018");
		chartOptions.getTooltip().setPointFormat("{series.name}: <b>{point.percentage:.1f}%</b>");
		
		chartOptions.getPlotOptions()
			.getPie()
				.setAllowPointSelect(true)
				.setCursor(Cursor.POINTER)
				.getDataLabels()
					.setEnabled(true)
					.setConnectorColor(new Color("silver"))
					.setFormat("<b>{point.name}</b>: {point.percentage:.1f} %")
					.getStyle().setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"));
		
		SeriesPie seriesPie = new SeriesPie();
		seriesPie.setName("Share");
		seriesPie.setDataAsArrayObject(getSeriesData());
		chartOptions.getSeries().add(seriesPie);
		
		// Create new colors list
		List<Color> newColors = new ArrayList<Color>();

		for (Color defaultColor : chartOptions.getColors()) {
			ArrayList<Stop> stops = new ArrayList<Stop>();
			stops.add(new Stop(0, new Color(defaultColor.getColor())));
			stops.add(new Stop(1, new Color(defaultColor.getColor()).brighten(-0.3)));
			
			newColors.add(new Color(new RadialGradient(0.5,  0.3, 0.7), stops));
		}
		
		chartOptions.setColors(newColors);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Data> getSeriesData() {
		ArrayList<Data> array = new ArrayList<Data>();
		
		array.add(new Data().setName("Chrome").setY(61.41));
		array.add(new Data().setName("Internet Explorer").setY(11.84));
		array.add(new Data().setName("Firefox").setY(10.85));
		array.add(new Data().setName("Edge").setY(4.67));
		array.add(new Data().setName("Safari").setY(4.18));
		array.add(new Data().setName("Other").setY(7.05));
		
		return array;
    }
}
