package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class PatternFillAreaChart extends DemoChartBase {
	private static final long serialVersionUID = -4352596114854844664L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
				
		chartOptions.getChart().setType(ChartType.AREA);
		chartOptions.getTitle().setText("Pattern Fill Area Demo");

		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));
		chartOptions.getXAxis().add(xAxi);
		
		chartOptions.getPlotOptions().getArea().getFillColor()
			.getPattern().setWidth(10).setHeight(10).setOpacity(0.4).getPathAsObject().setDAsString("M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11").setStrokeWidth(3);
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setColor(new Color("#88e")).getFillColor().getPattern().setColor(new Color("#11d"));
		seriesArea.setDataAsArrayNumber(Arrays.asList(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setColor(new Color("#e88")).getFillColor().getPattern().setColor(new Color("#d11"));
		seriesArea.setDataAsArrayNumber(Arrays.asList(null, null, null, null, null, 43.1, 95.6, 148.5, 216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}

}
