package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesItem;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ParliamentChart extends DemoChartBase {
	private static final long serialVersionUID = 7868991870875635989L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.ITEM);
		chartOptions.getTitle().setText("Highcharts item chart");
		chartOptions.getSubtitle().setText("Parliament visualization");

		chartOptions.getLegend().setLabelFormat("{name} <span style=\"opacity: 0.4\">{y}</span>");
		
		SeriesItem seriesItem = new SeriesItem();
		seriesItem.setName("Representatives");
		seriesItem.setKeys(Arrays.asList("name", "y", "color", "label"));
		seriesItem.setDataAsArrayJavaObject(getSeriesData());
		seriesItem.getDataLabels().setEnabled(true).setFormat("{point.label}");
		seriesItem.setCenterAsArrayString(Arrays.asList("50%", "88%"));
		seriesItem.setSizeAsString("170%").setStartAngle(-100).setEndAngle(100);
		
		chartOptions.getSeries().add(seriesItem);

		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		array.add(Arrays.asList("The Left", 69, "#BE3075", "DIE LINKE"));
		array.add(Arrays.asList("Social Democratic Party", 153, "#EB001F", "SPD"));
		array.add(Arrays.asList("Alliance 90/The Greens", 67, "#64A12D", "GRÜNE"));
		array.add(Arrays.asList("Free Democratic Party", 80, "#FFED00", "FDP"));
		array.add(Arrays.asList("Christian Democratic Union", 200, "#000000", "CDU"));
		array.add(Arrays.asList("Christian Social Union in Bavaria", 46, "#008AC5", "CSU"));
		array.add(Arrays.asList("Alternative for Germany", 94, "#009EE0", "AfD"));

    	return array;
    }
}
