package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesPareto;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ParetoChart extends DemoChartBase {
	private static final long serialVersionUID = 4156733705735424151L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Restaurants Complaints");
		
		chartOptions.getXAxisSingle()
			.setCategories(Arrays.asList("Overpriced", "Small portions", "Wait time", "Food is tasteless", 
							  			 "No atmosphere", "Not clean", "Too noisy", "Unfriendly staff"));

		YAxis yAxis = new YAxis();
		yAxis.getTitle().setText("");
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.getTitle().setText("");
		yAxis.setMinPadding(0)
			.setMaxPadding(0)
			.setMax(100)
			.setMin(0)
			.setOpposite(true)
			.getLabels()
			.setFormat("{value}%");
		chartOptions.getYAxis().add(yAxis);
		
		SeriesPareto seriesPareto = new SeriesPareto();
		seriesPareto.setType(SeriesType.PARETO)
			.setName("Pareto")
			.setYAxisAsNumber(1)
			.setZIndex(10)
			.setBaseSeriesAsNumber(1);

		chartOptions.getSeries().add(seriesPareto);
		
		seriesPareto = new SeriesPareto();
		seriesPareto.setType(SeriesType.COLUMN)
			.setName("Complaints")
			.setZIndex(2);
		seriesPareto.setDataAsArrayNumber(Arrays.asList(755, 222, 151, 86, 72, 51, 36, 10));
		chartOptions.getSeries().add(seriesPareto);
		
		return highChart;
	}
	
}
