package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesNetworkgraph;
import com.webonlineapp.hyjavachartsdemo7flow.chartdata.NetworkGraphData;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class NetworkGraph extends DemoChartBase {
	private static final long serialVersionUID = 6895751012791380221L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.NETWORKGRAPH);
		chartOptions.getTitle().setText("The Indo-European Laungauge Tree");
		chartOptions.getSubtitle().setText("A Force-Directed Network Graph in Highcharts");

		chartOptions.getPlotOptions().getNetworkgraph()
			.setKeys(Arrays.asList("from", "to"))
			.getLayoutAlgorithm().setEnableSimulation(true).setFriction(-0.9);
		
		SeriesNetworkgraph seriesNetworkgraph = new SeriesNetworkgraph();
		seriesNetworkgraph.setColorByPoint(true).getDataLabels().setEnabled(true).setLinkFormat("");
		seriesNetworkgraph.setDataAsArrayObject(new NetworkGraphData().getSeriesData());
		chartOptions.getSeries().add(seriesNetworkgraph);

		return highChart;
	}
	
	public NetworkGraph() {
		setHeight("600px");
	}

}
