package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class LogarithmicAxis extends DemoChartBase {
	private static final long serialVersionUID = -4112620980937430294L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getTitle().setText("Logarithmic axis demo");
		
		XAxis xAxi = new XAxis().setType(AxisType.LOGARITHMIC).setTickInterval(1);
		chartOptions.getXAxis().add(xAxi);
		
		YAxis yAxi = new YAxis().setType(AxisType.LOGARITHMIC).setMinorTickIntervalAsNumber(0.1);
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip()
			.setHeaderFormat("<b>{series.name}</b><br />")
			.setPointFormat("x = {point.x}, y = {point.y}");
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setPointStart(1);
		seriesLine.setDataAsArrayNumber(Arrays.asList(1, 2, 4, 8, 16, 32, 64, 128, 256, 512));
		chartOptions.getSeries().add(seriesLine);
		
		return highChart;
	}

}
