package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.text.DecimalFormat;
import java.util.ArrayList;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesLine;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class LineChartWith500kPoints extends DemoChartBase {
	private static final long serialVersionUID = 8032420527009114490L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
	    
		chartOptions.getChart().setZoomType(ZoomType.X);
		chartOptions.getBoost().setUseGPUTranslations(true);
		
		chartOptions.getTitle().setText("Highcharts drawing 500,000 points");
		chartOptions.getSubtitle().setText("Using the Boost module");
		
		chartOptions.getTooltip().setValueDecimals(2);
		
		SeriesLine seriesLine = new SeriesLine();
		seriesLine.setLineWidth(0.5);
		seriesLine.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesLine);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		int i;
		int n = 500000;
		double a = 0, b = 0, c = 0, spike = 0;
		DecimalFormat df = new DecimalFormat("#.##");
		
	    for (i = 0; i < n; i = i + 1) {
	    	if (i % 100 == 0) {
	    		a = 2 * Math.random();
	    	}
	    	
	    	if (i % 1000 == 0) {
	    		b = 2 * Math.random();
	    	}
	    	
	    	if (i % 10000 == 0) {
	    		c = 2 * Math.random();
	    	}
	    	
	    	if (i % 50000 == 0) {
	    		spike = 10;
	    	} 
	    	else {
	    		spike = 0;
	    	}
	    	
	    	ArrayList<Number> arrayNumber = new ArrayList<Number>();
	    	arrayNumber.add(i);
	    	arrayNumber.add(new Double(df.format(2 * Math.sin(i / 100) + a + b + c + spike + Math.random())));
	    	
	    	array.add(arrayNumber);
	    }

    	return array;
    }
	
	/**
	 * 
	 */
	public LineChartWith500kPoints() {
		this.setShowJson(false);
	}
}
