package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.HorizontalAlign;
import com.hyjavacharts.model.highcharts.constants.Layout;
import com.hyjavacharts.model.highcharts.constants.VerticalAlign;
import com.hyjavacharts.model.highcharts.series.SeriesArea;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class InvertedAxis extends DemoChartBase {
	private static final long serialVersionUID = -9089527103892166862L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.AREA)
			.setInverted(true);
		
		chartOptions.getTitle().setText("Average fruit consumption during one week");
		chartOptions.getSubtitle()
			.getStyle().setCssValue("{ position: 'absolute', right: '0px', bottom: '10px' }");

		chartOptions.getLegend()
			.setLayout(Layout.VERTICAL)
			.setAlign(HorizontalAlign.RIGHT)
			.setVerticalAlign(VerticalAlign.TOP)
			.setX(-150)
			.setY(100)
			.setFloating(true)
			.setBorderWidth(1)
			.setBackgroundColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'"));

		chartOptions.getXAxisSingle().setCategories(
			Arrays.asList("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"));

		chartOptions.getYAxisSingle()
			.setMin(0)
			.getTitle().setText("Number of units");
		chartOptions.getYAxisSingle()
			.getLabels().getFormatter().setFunctionBody("return this.value;");
		
		SeriesArea seriesArea = new SeriesArea();
		seriesArea.setName("John");
		seriesArea.setDataAsArrayNumber(Arrays.asList(3, 4, 3, 5, 4, 10, 12));
		chartOptions.getSeries().add(seriesArea);
		
		seriesArea = new SeriesArea();
		seriesArea.setName("Jane");
		seriesArea.setDataAsArrayNumber(Arrays.asList(1, 3, 4, 3, 3, 5, 4));
		chartOptions.getSeries().add(seriesArea);
		
		return highChart;
	}
	
}
