package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesHistogram;
import com.hyjavacharts.model.highcharts.series.SeriesScatter;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class Histogram extends DemoChartBase {
	private static final long serialVersionUID = 6355158762084036225L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Highcharts Histogram");

		XAxis xAxi = new XAxis();
		xAxi.getTitle().setText("Data");
		chartOptions.getXAxis().add(xAxi);
		
		xAxi = new XAxis();
		xAxi.setOpposite(true)
			.getTitle().setText("Histogram");
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Data");
		chartOptions.getYAxis().add(yAxi);
		
		yAxi = new YAxis();
		yAxi.setOpposite(true)
			.getTitle().setText("Histogram");
		chartOptions.getYAxis().add(yAxi);

		SeriesHistogram seriesHistogram = new SeriesHistogram();
		seriesHistogram.setType(SeriesType.HISTOGRAM)
			.setName("Histogram")
			.setXAxisAsNumber(1)
			.setYAxisAsNumber(1)
			.setBaseSeriesAsString("s1")
			.setZIndex(-1);
		chartOptions.getSeries().add(seriesHistogram);
		
		SeriesScatter seriesScatter = new SeriesScatter();
		seriesScatter.setType(SeriesType.SCATTER)
			.setName("Data")
			.setId("s1")
			.getMarker().setRadius(1.5);
		seriesScatter.setDataAsArrayNumber(Arrays.asList(
			3.5, 3, 3.2, 3.1, 3.6, 3.9, 3.4, 3.4, 2.9, 3.1, 3.7, 3.4, 3, 3, 4, 4.4, 3.9, 3.5, 3.8, 3.8, 3.4, 3.7, 3.6, 3.3, 
			3.4, 3, 3.4, 3.5, 3.4, 3.2, 3.1, 3.4, 4.1, 4.2, 3.1, 3.2, 3.5, 3.6, 3, 3.4, 3.5, 2.3, 3.2, 3.5, 3.8, 3, 3.8, 3.2, 
			3.7, 3.3, 3.2, 3.2, 3.1, 2.3, 2.8, 2.8, 3.3, 2.4, 2.9, 2.7, 2, 3, 2.2, 2.9, 2.9, 3.1, 3, 2.7, 2.2, 2.5, 3.2, 2.8, 
			2.5, 2.8, 2.9, 3, 2.8, 3, 2.9, 2.6, 2.4, 2.4, 2.7, 2.7, 3, 3.4, 3.1, 2.3, 3, 2.5, 2.6, 3, 2.6, 2.3, 2.7, 3, 2.9, 
			2.9, 2.5, 2.8, 3.3, 2.7, 3, 2.9, 3, 3, 2.5, 2.9, 2.5, 3.6, 3.2, 2.7, 3, 2.5, 2.8, 3.2, 3, 3.8, 2.6, 2.2, 3.2, 2.8, 
			2.8, 2.7, 3.3, 3.2, 2.8, 3, 2.8, 3, 2.8, 3.8, 2.8, 2.8, 2.6, 3, 3.4, 3.1, 3, 3.1, 3.1, 3.1, 2.7, 3.2, 3.3, 3, 2.5, 
			3, 3.4, 3));
		chartOptions.getSeries().add(seriesScatter);
		
		return highChart;
	}

}
