package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Stop;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.MinorTickPosition;
import com.hyjavacharts.model.highcharts.constants.TickPosition;
import com.hyjavacharts.model.highcharts.series.SeriesGauge;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;
import com.webonlineapp.hyjavachartsdemo7flow.services.RestService;

public class GaugeWithDualAxis extends DemoChartBase {
	private static final long serialVersionUID = 3239167960391096406L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.GAUGE)
			.setAlignTicks(false)
			.setPlotBorderWidth(0)
			.setPlotShadowAsBoolean(false)
			.setPlotBackgroundColor(null)
			.setPlotBackgroundImage(null)
			.setPlotShadowAsBoolean(false); 
		
		chartOptions.getTitle().setText("Speedometer with dual axes");

		chartOptions.getPaneSingle()
			.setStartAngle(-150)
			.setEndAngle(150);
		
		YAxis yAxis = new YAxis();
		yAxis.setMin(0)
			.setMax(200)
			.setLineColor(new Color("#339"))
			.setTickColor(new Color("#339"))
			.setOffset(-25)
			.setLineWidth(2)
			.setMinorTickColor(new Color("#339"))
			.setTickLength(5)
			.setMinorTickLength(5)
			.setEndOnTick(false)
			.getLabels().setDistanceAsNumber(-20);
		chartOptions.getYAxis().add(yAxis);
		
		yAxis = new YAxis();
		yAxis.setMin(0)
			.setMax(124)
			.setTickPosition(TickPosition.OUTSIDE)
			.setLineColor(new Color("#933"))
			.setLineWidth(2)
			.setMinorTickPosition(MinorTickPosition.OUTSIDE)
			.setTickColor(new Color("#933"))
			.setMinorTickColor(new Color("#933"))
			.setTickLength(5)
			.setMinorTickLength(5)
			.setOffset(-20)
			.setEndOnTick(false)
			.getLabels().setDistanceAsNumber(12);
		chartOptions.getYAxis().add(yAxis);

		SeriesGauge sg = new SeriesGauge();
		
		sg.getTooltip().setValueSuffix(" km/h");
		sg.setName("Speed").getDataAsArrayNumber().add(80);
		sg.getDataLabels().getFormatter()
			.setFunctionBody("var kmh = this.y, mph = Math.round(kmh * 0.621); return '<span style=\"color:#339\">' + kmh + ' km/h</span><br/>' + '<span style=\"color:#933\">' + mph + ' mph</span>';");

		sg.getDataLabels().getBackgroundColor()
			.setStops(new ArrayList<Stop>(Arrays.asList(new Stop(0, new Color("#DDD")), new Stop(1, new Color("#FFF")))))
			.getLinearGradient().setX1(0).setX2(0).setY1(0).setY2(1);
		
		chartOptions.getSeries().add(sg);
		
		chartOptions.getData().setCsvURL(RestService.getURI() + "/GaugeSpeedCSVData")
			.setEnablePolling(true)
			.setDataRefreshRate(3);
		
		return highChart;
	}

}
