package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesFunnel;
import com.hyjavacharts.model.highcharts.series.seriesfunnel.Data;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class FunnelChart extends DemoChartBase {
	private static final long serialVersionUID = 7054641741140954959L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.FUNNEL);
		chartOptions.getTitle().setText("Sales funnel");
		
		chartOptions.getPlotOptions()
			.getFunnel()
				.setCenterAsArrayString(Arrays.asList("40%", "50%"))
				.setNeckWidthAsString("30%")
				.setNeckHeightAsString("25%")
				.setWidthAsString("80%")
				.getDataLabels()
					.setEnabled(true)
					.setFormat("<b>{point.name}</b> ({point.y:,.0f})")
					.setColor(new Color().setColorValue("(Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'"))
					.setSoftConnector(true);
		
		chartOptions.getLegend().setEnabled(false);
		
		SeriesFunnel seriesFunnel = new SeriesFunnel();
		seriesFunnel.setName("Unique users");
		seriesFunnel.setDataAsArrayObject(Arrays.asList(
				new Data().setName("Website visits").setY(15654),
				new Data().setName("Downloads").setY(4064),
				new Data().setName("Requested price list").setY(1987),
				new Data().setName("Invoice sent").setY(976),
				new Data().setName("Finalized").setY(846)
			));
		chartOptions.getSeries().add(seriesFunnel);
		
		return highChart;
	}
	
}
