package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class FixedPlacementColumns extends DemoChartBase {
	private static final long serialVersionUID = -6370839651363393477L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setType(ChartType.COLUMN);
		chartOptions.getTitle().setText("Efficiency Optimization by Branch");
		
		XAxis xAxi = new XAxis();
		xAxi.setCategories(Arrays.asList("Seattle HQ", "San Francisco", "Tokyo"));
		chartOptions.getXAxis().add(xAxi);

		YAxis yAxi = new YAxis();
		yAxi.setMin(0).getTitle().setText("Employees");
		chartOptions.getYAxis().add(yAxi);
		yAxi = new YAxis();
		yAxi.setOpposite(true).getTitle().setText("Profit (millions)");
		chartOptions.getYAxis().add(yAxi);

		chartOptions.getLegend().setShadowAsBoolean(false);
		chartOptions.getTooltip().setShared(true);
		
		chartOptions.getPlotOptions().getColumn().setGrouping(false).setShadowAsBoolean(false).setBorderWidth(0);

		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setName("Employees")
			.setColor(new Color().setRGBA(165, 170, 217, 1))
			.setPointPadding(0.3)
			.setPointPlacementAsNumber(-0.2);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(150, 73, 20));
		chartOptions.getSeries().add(seriesColumn);

		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Employees Optimized")
			.setColor(new Color().setRGBA(126, 86, 134, .9))
			.setPointPadding(0.4)
			.setPointPlacementAsNumber(-0.2);
		seriesColumn.setDataAsArrayNumber(Arrays.asList(140, 90, 40));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Profit")
			.setColor(new Color().setRGBA(248, 161, 63, 1))
			.setPointPadding(0.3)
			.setPointPlacementAsNumber(0.2)
			.setYAxisAsNumber(1)
			.getTooltip().setValuePrefix("$").setValueSuffix(" M");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(183.6, 178.8, 198.5));
		chartOptions.getSeries().add(seriesColumn);
		
		seriesColumn = new SeriesColumn();
		seriesColumn.setName("Profit Optimized")
			.setColor(new Color().setRGBA(186, 60, 61, .9))
			.setPointPadding(0.4)
			.setPointPlacementAsNumber(0.2)
			.setYAxisAsNumber(1)
			.getTooltip().setValuePrefix("$").setValueSuffix(" M");
		seriesColumn.setDataAsArrayNumber(Arrays.asList(203.6, 198.8, 208.5));
		chartOptions.getSeries().add(seriesColumn);
		
		return highChart;
	}

}
