package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.constants.ZoomType;
import com.hyjavacharts.model.highcharts.series.SeriesColumn;
import com.hyjavacharts.model.highcharts.series.SeriesErrorbar;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class ErrorBar extends DemoChartBase {
	private static final long serialVersionUID = -4363841172534492789L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getChart().setZoomType(ZoomType.XY);
		chartOptions.getTitle().setText("Temperature vs Rainfall");

		chartOptions.getXAxisSingle().setCategories(Arrays.asList(
				"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"));

		YAxis yAxi = new YAxis();
		yAxi.getLabels()
			.setFormat("{value} °C")
			.getStyle()
			.setColor(chartOptions.getColors().get(1));
		yAxi.getTitle().setText("Temperature")
			.getStyle()
			.setColor(chartOptions.getColors().get(1));
		chartOptions.getYAxis().add(yAxi);
		
		yAxi = new YAxis();
		yAxi.setOpposite(true)
			.getLabels()
			.setFormat("{value} mm")
			.getStyle()
			.setColor(chartOptions.getColors().get(0));
		yAxi.getTitle()
			.setText("Rainfall")
			.getStyle()
			.setColor(chartOptions.getColors().get(0));
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip().setShared(true);
		
		SeriesColumn seriesColumn = new SeriesColumn();
		seriesColumn.setType(SeriesType.COLUMN)
			.setName("Rainfall")
			.setYAxisAsNumber(1)
			.getTooltip().setPointFormat("<span style=\"font-weight: bold; color: {series.color}\">{series.name}</span>: <b>{point.y:.1f} mm</b> ");
		seriesColumn.setDataAsArrayNumber(
			Arrays.asList(49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4));
		chartOptions.getSeries().add(seriesColumn);
		
		SeriesErrorbar seriesErrorbar = new SeriesErrorbar();
		seriesErrorbar.setType(SeriesType.ERRORBAR)
			.setName("Rainfall error")
			.setYAxisAsNumber(1)
			.getTooltip().setPointFormat("(error range: {point.low}-{point.high} mm)<br/>");
		seriesErrorbar.setDataAsArrayJavaObject(getSeriesErrorData(1));
		chartOptions.getSeries().add(seriesErrorbar);
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setType(SeriesType.SPLINE)
			.setName("Temperature")
			.getTooltip().setPointFormat("<span style=\"font-weight: bold; color: {series.color}\">{series.name}</span>: <b>{point.y:.1f}°C</b> ");
		seriesSpline.setDataAsArrayNumber(
			Arrays.asList(7.0, 6.9, 9.5, 14.5, 18.2, 21.5, 25.2, 26.5, 23.3, 18.3, 13.9, 9.6));
		chartOptions.getSeries().add(seriesSpline);

		seriesErrorbar = new SeriesErrorbar();
		seriesErrorbar.setType(SeriesType.ERRORBAR)
			.setName("Temperature error")
			.getTooltip().setPointFormat("(error range: {point.low}-{point.high}°C)<br/>");
		seriesErrorbar.setDataAsArrayJavaObject(getSeriesErrorData(2));
		chartOptions.getSeries().add(seriesErrorbar);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Object> getSeriesErrorData(int series) {
		ArrayList<Object> array = new ArrayList<Object>();
		
    	if (series == 1) {
    		array.add(Arrays.asList(48, 51));
    		array.add(Arrays.asList(68, 73));
    		array.add(Arrays.asList(92, 110));
    		array.add(Arrays.asList(128, 136));
    		array.add(Arrays.asList(140, 150));
    		array.add(Arrays.asList(171, 179));
    		array.add(Arrays.asList(135, 143));
    		array.add(Arrays.asList(142, 149));
    		array.add(Arrays.asList(204, 220));
    		array.add(Arrays.asList(189, 199));
    		array.add(Arrays.asList(95, 110));
    		array.add(Arrays.asList(52, 56));
     	}
    	else if (series == 2) {
    		array.add(Arrays.asList(6, 8));
    		array.add(Arrays.asList(5.9, 7.6));
    		array.add(Arrays.asList(9.4, 10.4));
    		array.add(Arrays.asList(14.1, 15.9));
    		array.add(Arrays.asList(18.0, 20.1));
    		array.add(Arrays.asList(21.0, 24.0));
    		array.add(Arrays.asList(23.2, 25.3));
    		array.add(Arrays.asList(26.1, 27.8));
    		array.add(Arrays.asList(23.2, 23.9));
    		array.add(Arrays.asList(18.0, 21.1));
    		array.add(Arrays.asList(12.9, 14.0));
    		array.add(Arrays.asList(7.6, 10.0));
    	}

    	return array;
    }
}
