package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Calendar;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.Function;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.GlobalOptions;
import com.hyjavacharts.model.highcharts.XAxis;
import com.hyjavacharts.model.highcharts.YAxis;
import com.hyjavacharts.model.highcharts.constants.AxisType;
import com.hyjavacharts.model.highcharts.constants.ChartType;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesSpline;
import com.hyjavacharts.model.highcharts.series.seriesspline.Data;
import com.hyjavacharts.model.highcharts.yaxis.PlotLines;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class DynamicSplineUpdating extends DemoChartBase {
	private static final long serialVersionUID = -4333244716808878085L;
	
	private String loadFunction = 
			"var series = this.series[0];" + 
			"setInterval(function () {" + 
					"var x = (new Date()).getTime()," + 
					"y = Math.random();" + 
					"series.addPoint([x, y], true, true);" + 
				"}, 1000);";
	
	public Highchart configure() {
		Highchart highChart = new Highchart();
		GlobalOptions globalOptions = highChart.getGlobalOptions();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		globalOptions.getGlobal().setUseUTC(false);
		
		chartOptions.getChart().setType(ChartType.SPLINE).setMarginRight(10).getEvents().setLoad(new Function(loadFunction));
		chartOptions.getTitle().setText("Live random data");
		chartOptions.getXAxis().add(new XAxis().setType(AxisType.DATETIME).setTickPixelInterval(150));
		
		YAxis yAxi = new YAxis();
		yAxi.getTitle().setText("Value");
		yAxi.getPlotLines().add(new PlotLines().setValue(0f).setWidth(1).setColor(new Color("#808080")));
		chartOptions.getYAxis().add(yAxi);
		
		chartOptions.getTooltip().getFormatter()
			.setFunctionBody("return '<b>'+ this.series.name +'</b><br/>'+"
                    + "Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', this.x) +'<br/>'+"
                    + "Highcharts.numberFormat(this.y, 2);");

		chartOptions.getLegend().setEnabled(true);
		chartOptions.getExporting().setEnabled(true);
		
		SeriesSpline seriesSpline = new SeriesSpline();
		seriesSpline.setType(SeriesType.SPLINE).setName("Random data");
		seriesSpline.setDataAsArrayObject(getSeriesData(1));
		chartOptions.getSeries().add(seriesSpline);
		
		return highChart;
	}
	
	/**
	 * 
	 * @param series
	 * @return
	 */
	private ArrayList<Data> getSeriesData(int series) {
		Calendar cal = Calendar.getInstance();
		long now = cal.getTime().getTime();
		
		ArrayList<Data> data = new ArrayList<Data>();
		data.add(new Data().setX(now-20000).setY(Math.random()));
		data.add(new Data().setX(now-19000).setY(Math.random()));
		data.add(new Data().setX(now-18000).setY(Math.random()));
		data.add(new Data().setX(now-17000).setY(Math.random()));
		data.add(new Data().setX(now-16000).setY(Math.random()));
		data.add(new Data().setX(now-15000).setY(Math.random()));
		data.add(new Data().setX(now-14000).setY(Math.random()));
		data.add(new Data().setX(now-13000).setY(Math.random()));
		data.add(new Data().setX(now-12000).setY(Math.random()));
		data.add(new Data().setX(now-11000).setY(Math.random()));
		data.add(new Data().setX(now-10000).setY(Math.random()));
		data.add(new Data().setX(now-9000).setY(Math.random()));
		data.add(new Data().setX(now-8000).setY(Math.random()));
		data.add(new Data().setX(now-7000).setY(Math.random()));
		data.add(new Data().setX(now-6000).setY(Math.random()));
		data.add(new Data().setX(now-5000).setY(Math.random()));
		data.add(new Data().setX(now-4000).setY(Math.random()));
		data.add(new Data().setX(now-3000).setY(Math.random()));
		data.add(new Data().setX(now-2000).setY(Math.random()));
		data.add(new Data().setX(now-1000).setY(Math.random()));
		data.add(new Data().setX(now).setY(Math.random()));
		
		return data;
	}

}
