package com.webonlineapp.hyjavachartsdemo7flow.examplecharts;

import java.util.ArrayList;
import java.util.Arrays;

import com.hyjavacharts.chart.Highchart;
import com.hyjavacharts.model.common.Color;
import com.hyjavacharts.model.common.GenericOption;
import com.hyjavacharts.model.highcharts.ChartOptions;
import com.hyjavacharts.model.highcharts.constants.SeriesType;
import com.hyjavacharts.model.highcharts.series.SeriesDependencywheel;
import com.webonlineapp.hyjavachartsdemo7flow.charts.DemoChartBase;

public class DependencyWheel extends DemoChartBase {
	private static final long serialVersionUID = 5231957568931100103L;

	public Highchart configure() {
		Highchart highChart = new Highchart();
		ChartOptions chartOptions = highChart.getChartOptions();
		
		chartOptions.getTitle().setText("Highcharts Dependency Wheel");
		
		SeriesDependencywheel seriesDependencywheel = new SeriesDependencywheel();
		seriesDependencywheel.setType(SeriesType.DEPENDENCYWHEEL);
		seriesDependencywheel.setName("Dependency wheel series");
		seriesDependencywheel.setKeys(Arrays.asList("from", "to", "weight"));
		seriesDependencywheel.setSizeAsString("95%");
		seriesDependencywheel.getDataLabels()
			.setColor(new Color("#333"))
			.setDistance(10).getTextPath().setEnabled(true).getAttributes().get_genericOption().add(new GenericOption("dy", "5"));
		seriesDependencywheel.setDataAsArrayJavaObject(getSeriesData());
		chartOptions.getSeries().add(seriesDependencywheel);
		
		return highChart;
	}
	
	/**
	 * 
	 * @return
	 */
	public ArrayList<Object> getSeriesData() {
		ArrayList<Object> array = new ArrayList<Object>();
		
		array.add(Arrays.asList("Brazil", "Portugal", 5));
		array.add(Arrays.asList("Brazil", "France", 1));
		array.add(Arrays.asList("Brazil", "Spain", 1));
		array.add(Arrays.asList("Brazil", "England", 1));
		array.add(Arrays.asList("Canada", "Portugal", 1));
		array.add(Arrays.asList("Canada", "France", 5));
		array.add(Arrays.asList("Canada", "England", 1));
		array.add(Arrays.asList("Mexico", "Portugal", 1));
		array.add(Arrays.asList("Mexico", "France", 1));
		array.add(Arrays.asList("Mexico", "Spain", 5));
		array.add(Arrays.asList("Mexico", "England", 1));
		array.add(Arrays.asList("USA", "Portugal", 1));
		array.add(Arrays.asList("USA", "France", 1));
		array.add(Arrays.asList("USA", "Spain", 1));
		array.add(Arrays.asList("USA", "England", 5));
		array.add(Arrays.asList("Portugal", "Angola", 2));
		array.add(Arrays.asList("Portugal", "Senegal", 1));
		array.add(Arrays.asList("Portugal", "Morocco", 1));
		array.add(Arrays.asList("Portugal", "South Africa", 3));
		array.add(Arrays.asList("France", "Angola", 1));
		array.add(Arrays.asList("France", "Senegal", 3));
		array.add(Arrays.asList("France", "Mali", 3));
		array.add(Arrays.asList("France", "Morocco", 3));
		array.add(Arrays.asList("France", "South Africa", 1));
		array.add(Arrays.asList("Spain", "Senegal", 1));
		array.add(Arrays.asList("Spain", "Morocco", 3));
		array.add(Arrays.asList("Spain", "South Africa", 1));
		array.add(Arrays.asList("England", "Angola", 1));
		array.add(Arrays.asList("England", "Senegal", 1));
		array.add(Arrays.asList("England", "Morocco", 2));
		array.add(Arrays.asList("England", "South Africa", 7));
		array.add(Arrays.asList("South Africa", "China", 5));
		array.add(Arrays.asList("South Africa", "India", 1));
		array.add(Arrays.asList("South Africa", "Japan", 3));
		array.add(Arrays.asList("Angola", "China", 5));
		array.add(Arrays.asList("Angola", "India", 1));
		array.add(Arrays.asList("Angola", "Japan", 3));
		array.add(Arrays.asList("Senegal", "China", 5));
		array.add(Arrays.asList("Senegal", "India", 1));
		array.add(Arrays.asList("Senegal", "Japan", 3));
		array.add(Arrays.asList("Mali", "China", 5));
		array.add(Arrays.asList("Mali", "India", 1));
		array.add(Arrays.asList("Mali", "Japan", 3));
		array.add(Arrays.asList("Morocco", "China", 5));
		array.add(Arrays.asList("Morocco", "India", 1));
		array.add(Arrays.asList("Morocco", "Japan", 3));
		array.add(Arrays.asList("Japan", "Brazil", 1));

    	return array;
    }
}
